// -*- c++ -*-

//-------------------------------------------------------------------------
// Author: Daniel Kps, created 2006.
// This file is public domain.
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// NOTES
// - some macros currently require use of stx/sontaia StxPrimitives.h and/or
//   StxBasicType.h (specifically M_DeclareBitProperty() etc.)
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
//
// NOTE ...WithoutSet() macro variants may be useful if :
// - ParameterType doesn't support assignment
// - if specialized set[ParameterType]() function is required which does
//   more than just assigning the value (e.g. updating other internal
//   variables)

#define M_DeclarePtrPropertyWithoutSet(ParameterType,ParameterName) \
  public:                                                      \
    ParameterType * get##ParameterName () const \
    { \
      return m_##ParameterName; \
    } \
 private: \
    ParameterType * m_##ParameterName \

#define M_DeclarePtrProperty(ParameterType,ParameterName) \
  public:                                                      \
    void set##ParameterName (ParameterType * ParameterName) \
    { \
      m_##ParameterName = ParameterName; \
    } \
    M_DeclarePtrPropertyWithoutSet(ParameterType,ParameterName) \

//-------------------------------------------------------------------------

#define M_DeclarePropertyWithoutSet(ParameterType,ParameterName) \
  public:                                                      \
    const ParameterType & get##ParameterName () const \
    { \
      return m_##ParameterName; \
    } \
    ParameterType & access##ParameterName () \
    { \
      return m_##ParameterName; \
    } \
    bool getIs##ParameterName##Initialized () const \
    { \
      return m_Is##ParameterName##Initialized; \
    } \
    void set##ParameterName##InitializedState (bool IsInitialized = true) \
    { \
      m_Is##ParameterName##Initialized = IsInitialized; \
    } \
 private: \
    ParameterType m_##ParameterName; \
    bool m_Is##ParameterName##Initialized \

//-------------------------------------------------------------------------

#define M_DeclareProperty(ParameterType,ParameterName) \
  public:                                                      \
    void set##ParameterName (const ParameterType & ParameterName) \
    { \
      m_##ParameterName = ParameterName; \
      m_Is##ParameterName##Initialized = true; \
    } \
    M_DeclarePropertyWithoutSet(ParameterType,ParameterName) \

//-------------------------------------------------------------------------

#define M_DeclarePropertyWithoutSetWithoutInitState(ParameterType,ParameterName) \
  public:                                                      \
    const ParameterType & get##ParameterName () const \
    { \
      return m_##ParameterName; \
    } \
    ParameterType & access##ParameterName () \
    { \
      return m_##ParameterName; \
    } \
 private: \
    ParameterType m_##ParameterName \

//-------------------------------------------------------------------------

#define M_DeclarePropertyWithoutInitState(ParameterType,ParameterName) \
  public:                                                      \
    void set##ParameterName (const ParameterType & ParameterName) \
    { \
      m_##ParameterName = ParameterName; \
    } \
    M_DeclarePropertyWithoutSetWithoutInitState(ParameterType,ParameterName) \

//-------------------------------------------------------------------------

#define M_DeclareBitProperty(ModeBits,ParameterName)           \
  public:                                                      \
    void set##ParameterName (bool IsEnable) \
    { \
      ::stxEnableBit (m_ModeBits, ParameterName, IsEnable); \
    } \
    bool get##ParameterName () \
    { \
      return ::stxGetBit (ModeBits, ParameterName); \
    } \

#define M_DeclareModeBits(EMode,ModeBits) \
  public: \
    bool get##ModeBits (EMode Mode) { return ::stxGetBit (ModeBits, Mode); } \
    void enable##ModeBits (EMode Mode, bool IsEnable) { ::stxEnableBit (ModeBits, Mode, IsEnable); } \
  private: \
    EMode m_ModeBits \

//-------------------------------------------------------------------------
