//-------------------------------------------------------------------------
// Licence:     wxWidgets licence
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------

/*
//-------------------------------------------------------------------------

=== WxExtLibTest Configuration

== Test use of notebook pages

- notes:
  - automatic sizing for notebook pages doesn't seem to work
  - well (for whatever reason)
- settings:
    #define M_WxExtLibTest_IsNotebookPanelTest 0/1

//-------------------------------------------------------------------------
*/

#define M_IsTestHtmlController

#include "WxExtLibConfig.h"
#include "WxExtLibConfig_Version.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include <wx/defs.h>

#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include <wx/list.h>
#include <wx/statline.h>
#include <wx/notebook.h>

// the application icon (under Windows and OS/2 it is in resources)
#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "WxExtLibTest.xpm"
#endif

#include "WxExtDialog.h"
#include "MessageExtDialog.h"
#include "WxMisc.h"

//-------------------------------------------------------------------------

#if wxUSE_MS_HTML_HELP && !defined(__WXUNIVERSAL__)
#   define M_IsUseChmHelpController
#   include "wx/msw/helpchm.h"
#else
#   include "wx/filesys.h"
#   include "wx/fs_zip.h"
#   include "wx/html/helpctrl.h"
#endif

//-------------------------------------------------------------------------

#include "ConfigEntry.h"
#include <wx/fileconf.h>
// #if defined(__WXMSW__)
// #   include <wx/msw/regconf.h>
// #   include <wx/msw/iniconf.h>
// #endif

#include <accessor_macros.h>

//-------------------------------------------------------------------------

#if defined(__WXMSW__)
const char * ConfigFilenameString = ".\\WxExtLibTest.ini";
#else
const char * ConfigFilenameString = "./WxExtLibTest.ini";
#endif

//=========================================================================

double BorderCompressionValue = 1.;

class WxExtLibTestFrame;

//-------------------------------------------------------------------------

class WxExtLibTestApp : public wxApp
{
public:
    virtual bool OnInit();

    void updateLanguageSettings ();

#if (M_WxExtLib_IsUseAppRootFrame == 1)
    // TEST AppRootFrame
    wxAppRootFrame & getAppRootFrame () { return * wxGetGlobalAppRootFrame(); }
#endif // M_WxExtLib_IsUseAppRootFrame

    WxExtLibTestFrame & getFrame () { return *m_WxExtLibTestFrame; }

    virtual void SetActive (bool IsActive, wxWindow * LastFocus);

private:
    bool m_IsAppInitialized;

	wxLocale * m_Locale;

    // TEST DummyMain
    WxExtLibTestFrame * m_WxExtLibTestFrame;

#if (M_WxExtLib_IsUseStxLogging == 1)
    stxAutoInitExit m_SontaiaAutoInitExit;
#endif
};

//-------------------------------------------------------------------------

inline WxExtLibTestApp & getApp()
{ 
    return * ((WxExtLibTestApp *) wxTheApp);
}

//-------------------------------------------------------------------------

class WxExtLibTestNonModalDialogManag : public wxNonModalDialogManag
{
 public:
    virtual wxWindow * createWindow (long CommandIdent);

    M_DeclarePtrProperty (wxWindow, ParentWindow);
};

//-------------------------------------------------------------------------

// TEST wxDialog as base class, but this doesn't support menus 
// in wxWidgets, apparently
typedef wxFrame WxExtLibTestBase;

class WxExtLibTestFrame : public WxExtLibTestBase
{
public:
    WxExtLibTestFrame (wxWindow * ParentWindow, 
                       const wxString& title, const wxPoint& pos, const wxSize& size,
                       long style = wxDEFAULT_FRAME_STYLE);

    void OnCloseEvent (wxCloseEvent & CloseEvent);
    void OnQuit (wxCommandEvent & Event);

    void OnMessageExtDialogTest (wxCommandEvent & Event);
    void OnStatusValidatorTestDialog (wxCommandEvent & Event);
    void OnMessageFormatterTest (wxCommandEvent & Event);
    void OnConfigEntryManagerTestDialog (wxCommandEvent & Event);
    void OnTextCtrlSliderPairTestDialog (wxCommandEvent & Event);
    void OnDialogZoomTestDialog (wxCommandEvent & Event);

    void OnNonModalDialog1 (wxCommandEvent & Event);
    void OnNonModalDialog2 (wxCommandEvent & Event);
    void OnNonModalDialog3 (wxCommandEvent & Event);

    void OnHelp (wxCommandEvent & Event);
    void OnAbout (wxCommandEvent & Event);

    // wxHelpController    m_HelpController;
#ifdef M_IsUseChmHelpController
    wxCHMHelpController m_ChmHelpController;
#else
    wxHtmlHelpController m_HtmlHelpController;
#endif

public:
    M_DeclarePropertyWithoutSet (WxExtLibTestNonModalDialogManag, NonModalDialogManag);

private:
    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxStatusValidatorTestExtDialog: public wxExtDialog
{
public:
    wxStatusValidatorTestExtDialog (wxWindow * ParentWindow);

    void createValidatorTestControls (wxWindowAdder & WA);

	virtual void OnOK(wxCommandEvent& Event);
	virtual void OnCancel(wxCommandEvent& Event);

    virtual void handleWatchedControlChange(wxCommandEvent& Event);

private:

    wxMultiLineText m_DescriptionMultiLineText;
    wxNotebook * m_Notebook;

    wxTextCtrl * m_IntegerTextCtrl;
    wxTextCtrl * m_DoubleTextCtrl;
    wxTextCtrl * m_AnotherDoubleTextCtrl;
    wxTextCtrl * m_GroupTestDoubleTextCtrl;
    wxTextCtrl * m_DateTimeTextCtrl;
    wxTextCtrl * m_StringTextCtrl;
    wxComboBox * m_AnotherStringComboBox;
    wxTextCtrl * m_SomeFilenameTextCtrl;

    int m_Integer;
    double m_Double;
    double m_AnotherDouble;
    double m_GroupTestDouble;
    wxDateTime m_DateTime;
    wxString m_String;
    wxString m_AnotherString;
    wxString m_SomeFilenameString;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxFormatMessageTestExtDialog: public wxExtDialog
{
public:
    wxFormatMessageTestExtDialog (wxWindow * ParentWindow);

	virtual void OnOK(wxCommandEvent& Event);
	virtual void OnEvaluate14(wxCommandEvent& Event);
	virtual void OnCancel(wxCommandEvent& Event);

private:

    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_Parameter1IntegerTextCtrl;
    wxTextCtrl * m_Parameter2StringTextCtrl;
    wxTextCtrl * m_Parameter3TextCtrl;
    wxTextCtrl * m_Parameter4TextCtrl;

    wxTextCtrl * m_FormatStringTextCtrl;

    int m_Parameter1Integer;
    wxString m_Parameter2String;
    int m_Parameter3Integer;
    int m_Parameter4Integer;

    wxString m_FormatString;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxExtLibTestConfigEntryManager : public wxConfigEntryManager
{
  public:
    wxExtLibTestConfigEntryManager ();
    void init ();

  public:
    wxStringConfigEntry  m_SomePathString;
    wxBooleanConfigEntry m_IsSomeValueEnabled;
    wxBooleanConfigEntry m_IsSomeOtherValueEnabled;
    wxIntegerConfigEntry m_Integer1;
    wxDoubleConfigEntry m_Double1;

    // it is possible to put wxConfigEntry objects in a sub-structure to
    // avoid very long variable identifiers or to re-use the same
    // identifier
    struct tag_Struct1
	{
	  wxIntegerConfigEntry m_Integer1;
	  wxIntegerConfigEntry m_Integer2;
	  wxBooleanConfigEntry m_IsSomeValueEnabled;
	} m_Struct1;

  private:
    bool m_IsInitialized;
};

extern wxExtLibTestConfigEntryManager WxExtLibTestConfigEntryManager;

//-------------------------------------------------------------------------

class wxConfigEntryManagerTestExtDialog: public wxExtDialog
{
public:
    wxConfigEntryManagerTestExtDialog (wxWindow * ParentWindow);

	virtual void OnRead (wxCommandEvent& Event);
	virtual void OnWriteModified (wxCommandEvent& Event);
	virtual void OnSetToDefaults (wxCommandEvent& Event);
	virtual void OnCancel (wxCommandEvent& Event);

    void setValuesToDialog();
    void setValuesToConfig();

private:
    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_SomePathStringTextCtrl;
    wxCheckBox * m_IsSomeValueEnabledCheckBox;
    wxCheckBox * m_IsSomeOtherValueEnabledCheckBox;
    wxTextCtrl * m_Integer1TextCtrl;
    wxTextCtrl * m_Double1TextCtrl;
    wxTextCtrl * m_Struct1_Integer1TextCtrl;
    wxTextCtrl * m_Struct1_Integer2TextCtrl;
    wxCheckBox * m_Struct1_IsSomeValueEnabledCheckBox;

    wxString m_SomePathString;
    bool m_IsSomeValueEnabled;
    bool m_IsSomeOtherValueEnabled;
    int m_Integer1;
    double m_Double1;
    int m_Struct1_Integer1;
    int m_Struct1_Integer2;
    bool m_Struct1_IsSomeValueEnabled;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxTextCtrlSliderPairTestExtDialog: public wxExtDialog
{
public:
    wxTextCtrlSliderPairTestExtDialog (wxWindow * ParentWindow);

	virtual void OnOK(wxCommandEvent& Event);
	virtual void OnCancel(wxCommandEvent& Event);

private:

    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_RedModificationTextCtrl;
    wxSlider * m_RedModificationSliderCtrl;
    wxTextCtrl * m_GreenModificationTextCtrl;
    wxSlider * m_GreenModificationSliderCtrl;
    wxTextCtrl * m_BlueModificationTextCtrl;
    wxSlider * m_BlueModificationSliderCtrl;

	long m_RedModificationLong;
	long m_GreenModificationLong;
	long m_BlueModificationLong;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxDialogZoomTestExtDialog: public wxExtDialog
{
public:
    wxDialogZoomTestExtDialog (wxWindow * ParentWindow);

    virtual void OnOK (wxCommandEvent& Event);

private:
    wxMultiLineText m_DescriptionMultiLineText;

    double m_DialogZoom;

    wxTextCtrl * m_DialogZoomTextCtrl;
    wxTextCtrl * m_BorderCompressionTextCtrl;

    DECLARE_EVENT_TABLE()
};

//=========================================================================

// IDs for the controls and the menu commands
enum
{
    // menu items
    ID_Quit = 1,

    // special id for about menu entry:
    ID_About = wxID_ABOUT,

	ID_MessageExtDialogTest = 33000,
	ID_StatusValidatorTestDialog,
	ID_FormatMessageTestDialog,
	ID_ConfigEntryManagerTestDialog,
	ID_TextCtrlSliderPairTestDialog,
	ID_DialogZoomTestDialog,

	ID_NonModalDialog1,
	ID_NonModalDialog2,
	ID_NonModalDialog3,

    ID_Help
};

//-------------------------------------------------------------------------

wxWindow * WxExtLibTestNonModalDialogManag::createWindow (long CommandIdent)
{
    wxWindow * Window = NULL;
    if (CommandIdent == ID_NonModalDialog1)
      {
        Window = new wxStatusValidatorTestExtDialog (getParentWindow());
      }
    else if (CommandIdent == ID_NonModalDialog2)
      {
        Window = new wxStatusValidatorTestExtDialog (getParentWindow());
      }
    else if (CommandIdent == ID_NonModalDialog3)
      {
        Window = new wxStatusValidatorTestExtDialog (getParentWindow());
      }
    else
      {
        wxASSERT_MSG (false, "createWindow(): unhandled CommandIdent");
        return NULL;
      }

#if (M_WxExtLib_IsUseAppRootFrame == 1)
    if (Window != NULL)
      {
        if (wxGetGlobalAppRootFrame() != NULL)
          wxGetGlobalAppRootFrame() -> connectTLWEventHandlers (Window);
      }
#endif // M_WxExtLib_IsUseAppRootFrame

    return Window;
}

//----------------------------------------------------------------------------
// wxStatusValidatorTestExtDialog

BEGIN_EVENT_TABLE (wxStatusValidatorTestExtDialog, wxExtDialog)
  // EVT_MENU   (wxID_HELP, wxStatusValidatorTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * StatusValidatorsDescriptionHtmlString;

int WxExtLibTest_Integer = 42;
double WxExtLibTest_Double = 8.12;
double WxExtLibTest_AnotherDouble = 14.01;
double WxExtLibTest_GroupTestDouble = 14902.01;
wxDateTime WxExtLibTest_DateTime;
wxString WxExtLibTest_String = "abcd";
wxString WxExtLibTest_AnotherString = "ab 01";
wxString WxExtLibTest_SomeFilenameString = "~/.profile";

//-------------------------------------------------------------------------

wxStatusValidatorTestExtDialog::wxStatusValidatorTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
                 -1, 
                 _("StatusValidators test dialog"),
                 wxDefaultPosition, 
                 wxDefaultSize,
                 wxCAPTION | wxRESIZE_BORDER)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	// initialize values
	m_Integer = WxExtLibTest_Integer;
	m_Double = WxExtLibTest_Double;
	m_AnotherDouble = WxExtLibTest_AnotherDouble;
	m_GroupTestDouble = WxExtLibTest_GroupTestDouble;
	m_DateTime = WxExtLibTest_DateTime;
	m_String = WxExtLibTest_String;
	m_AnotherString = WxExtLibTest_AnotherString;
	m_SomeFilenameString = WxExtLibTest_SomeFilenameString;

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------
    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
    wxSizerAdder PanelSizerAdder (PanelSizer);

    //-------------------------------------------------------------------------
    // use new wxWindowAdder class:

    wxWindowAdder WA;
    WA.setDialog (this);

    this -> SetExtraStyle (this -> GetExtraStyle()
                           | wxWS_EX_VALIDATE_RECURSIVELY);

    WA.pushSizer (/* new wxBoxSizer (wxVERTICAL) */ PanelSizer);

#if (M_WxExtLibTest_IsNotebookPanelTest == 1)

    // automatic sizing for notebook pages doesn't seem to work
    // well (for whatever reason)

    wxColourBarWindow * ColourBarWindow2 = new wxColourBarWindow (WA.getAddParentWindow(), -1, wxColour (255, 192, 255),
                                                                  wxDefaultPosition, /* wxSize (500, 120) */ wxDefaultSize,
                                                                  wxTAB_TRAVERSAL | wxNO_BORDER);
    WA.pushOverlay (ColourBarWindow2, wxOverlayAdder::IsAddOnPop);

#endif

    // WA.accessDefaults().setLabelFontColour (*wxRED);

#if (M_WxExtLibTest_IsNotebookPanelTest == 1)

    {

      long NotebookFlags = wxNB_TOP | wxNB_MULTILINE;

      // wxNotebook::DoGetBestSize was implemented from wx-version >= 2.5.0
      // so need to manually set size when using older wx-versions than 2.5.0
      // for wxNotebook
      m_Notebook = new wxNotebook (WA.getAddParentWindow(), wxID_AUTO,
                                   wxDefaultPosition, /*wxDefaultSize*/ wxSize (100, 400),
                                   NotebookFlags);
      WA.addWindow (m_Notebook);

      // use wxColourBarWindow instead of default wxPanel or wxWindow
      wxColourBarWindow * ColourBarWindow2 = new wxColourBarWindow (m_Notebook, -1, wxColour (192, 192, 255),
                                                                    wxDefaultPosition, /* wxSize (500, 120) */ wxDefaultSize,
                                                                    wxTAB_TRAVERSAL | wxNO_BORDER);
      wxWindow * NotebookPagePanel = ColourBarWindow2;

      m_Notebook -> AddPage (NotebookPagePanel, _("nb-page1"));

      WA.pushOverlay (NotebookPagePanel, wxOverlayAdder::ZeroModeBits);

      createValidatorTestControls (WA);

      WA.popSizer();

      WA.popOverlay();

      //-------------------------------------------------------------------------
      wxColourBarWindow * ColourBarWindow3 = new wxColourBarWindow (m_Notebook, -1, wxColour (255, 255, 192),
                                                                    wxDefaultPosition, /* wxSize (500, 120) */ wxDefaultSize,
                                                                    wxTAB_TRAVERSAL | wxNO_BORDER);
      NotebookPagePanel = ColourBarWindow3;
      m_Notebook -> AddPage (NotebookPagePanel, _("nb-page2"));

      WA.pushOverlay (NotebookPagePanel, wxOverlayAdder::ZeroModeBits);
      {
        {
          WA.addLabel (NULL, _("2nd page contents"));
          WA.next();
        }

        {
#if (M_WxExtLib_IsUseGraphicsHelper == 1)
          // WARN hardcoded relative path
          wxImage Image ("../../image/ice-gradient-01.png");
          wxScaledImageWindow * ScaledImageWindow
            = new wxScaledImageWindow (WA.getAddParentWindow(), -1, Image,
                                       wxDefaultPosition, wxSize (50, 400) /* wxDefaultSize */,
                                       wxTAB_TRAVERSAL | wxNO_BORDER);

          // WA.pushOverlay (ScaledImageWindow, wxOverlayAdder::IsAddOnPop);
          WA.addWindow (ScaledImageWindow);
#else
          wxColourBarWindow * ColourBarWindow4
            = new wxColourBarWindow (m_Notebook, -1, wxColour (255, 255, 192),
                                     wxDefaultPosition, /* wxSize (500, 120) */ wxDefaultSize,
                                     wxTAB_TRAVERSAL | wxNO_BORDER);
          WA.addWindow (ColourBarWindow4);
#endif
        }
      }
      WA.popOverlay();
      
    }

#else

    createValidatorTestControls (WA);

#endif

    {
      WA.addSpace (_B(10), _B(10));
      WA.addAndPushFlexGridSizer (4);
      {
        WA.addButton (_("&OK"),
                      NULL, wxID_OK,
                      (wxCommandEventFunction) (& wxStatusValidatorTestExtDialog::OnOK));
        WA.setDefaultButton ();

        WA.addButton (_("Cancel"),
                      NULL, wxID_CANCEL, 
                      (wxCommandEventFunction) (& wxStatusValidatorTestExtDialog::OnCancel));
      }
      WA.popSizer();
      WA.addSpace (_B(10), _B(10));
    }

#if (M_WxExtLibTest_IsNotebookPanelTest == 1)
    WA.popOverlay();
#endif

    WA.popSizer();

    //-------------------------------------------------------------------------
    PanelSizer -> Add (m_ErrorMessageMultiLineText.getWindow(),
                       0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);
    Layout();
    Fit ();

	initializeDialog ();
	enableWatchedControlChangeNotification (true);
}

void wxStatusValidatorTestExtDialog::createValidatorTestControls (wxWindowAdder & WA)
{
      WA.setSize (getAdjustedTextCtrlWidth (400),
                  getAdjustedTextCtrlHeight (1, true));
      WA.addMultiLineText (& m_DescriptionMultiLineText,
                           0,
                           wxMultiLineText::wxHTML_MODE,
                           StatusValidatorsDescriptionHtmlString,
                           4, 8, 
                           _B(10));
      m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

      wxSize StringTextCtrlSize (getAdjustedTextCtrlWidth (150),
                                 getAdjustedTextCtrlHeight (1, true));

      WA.addAndPushFlexGridSizer (1, true);
      {
      wxColourBarWindow * ColourBarWindow2 = new wxColourBarWindow (WA.getAddParentWindow(), -1, wxColour (192, 255, 192),
                                                                    wxDefaultPosition, /* wxSize (500, 120) */ wxDefaultSize,
                                                                    wxTAB_TRAVERSAL | wxNO_BORDER);
      ColourBarWindow2 -> setRoundedCornerRadius (5.);
      ColourBarWindow2 -> setPen (wxPen (wxColour (128, 128, 128), 1, wxSOLID));
      WA.pushOverlay (ColourBarWindow2, wxOverlayAdder::IsAddOnPop);
      WA.addAndPushFlexGridSizer (1, true);

      WA.addAndPushFlexGridSizer (2);
      {
        {
          WA.setLabel (_("Some &integer number"));
          WA.setSize (StringTextCtrlSize);
          WA.addTextCtrl  (& m_IntegerTextCtrl, 0);
          WA.setValidator (wxNumberValidator (& m_Integer, 10, 99, 
                                              m_StatusMessageTarget, 
                                              WA.getFullName()));
        }
        {
          WA.setLabel (_("Some &double number"));
          WA.setSize (StringTextCtrlSize);
          WA.addTextCtrl (& m_DoubleTextCtrl, 0);
          WA.setValidator (wxNumberValidator (& m_Double, 4.4, 55.2327, 
                                              m_StatusMessageTarget, 
                                              WA.getFullName(),
                                              wxNumberValidator::IsEmptyAllowed,
                                              "%.2f"));
        }
        {
          WA.setLabel (_("Another do&uble number"));
          WA.setSize (StringTextCtrlSize);
          WA.addTextCtrl (& m_AnotherDoubleTextCtrl, 0);
          WA.setValidator (wxNumberValidator (& m_AnotherDouble, 
                                              10., 20., 
                                              m_StatusMessageTarget, _("another double number"),
                                              wxNumberValidator::IsEmptyAllowed 
                                              | wxNumberValidator::IsIgnoreMinimum
                                              /* | wxNumberValidator::IsIgnoreMaximum */,
                                              "%.3f"));
        }
#if 0
        {
          WA.setLabel (_("Grouping test double"));
          WA.setSize (StringTextCtrlSize);
          WA.addTextCtrl (& m_GroupTestDoubleTextCtrl, 0);
          WA.setValidator (wxNumberValidator (& m_GroupTestDouble, -1E100, 1E100, 
                                              m_StatusMessageTarget, 
                                              WA.getFullName(),
                                              wxNumberValidator::IsEmptyAllowed,
                                              "%f"));
          WA.watchControl();
        }
#endif
      }
      WA.popSizer();

      // TEST overlay a few controls onto a wxColourBarWindow
      wxColourBarWindow * ColourBarWindow = new wxColourBarWindow (WA.getAddParentWindow(), -1, wxColour (255, 192, 192),
                                                                   wxDefaultPosition, /* wxSize (500, 120) */ wxDefaultSize,
                                                                   wxTAB_TRAVERSAL | wxNO_BORDER);
      ColourBarWindow -> setRoundedCornerRadius (5.);
      ColourBarWindow -> setPen (wxPen (wxColour (128, 128, 128), 1, wxSOLID));

      WA.pushOverlay (ColourBarWindow, wxOverlayAdder::IsAddOnPop);

      // WA.addAndPushSizer (new wxBoxSizer(wxVERTICAL), wxEXPAND, _B(10));
      WA.accessDefaults().setSizerBorder (_B(6));
      WA.addAndPushFlexGridSizer (1, true, true);
      // // WA.addSpace (_B(10), _B(10));

      {
        WA.addHeadline (_("headline for group"));
        WA.next();
      }

      WA.addAndPushFlexGridSizer (2);
      {
        WA.pushDefaults();
        WA.accessDefaults().setLabelFontColour (wxColour (32, 32, 128));
        WA.accessDefaults().setLabelBackgroundColour (*wxWHITE);

        {
          WA.setLabel (_("Some d&ate"));
          WA.setSize (getAdjustedTextCtrlWidth (240),
                      getAdjustedTextCtrlHeight (1, true));
          WA.addTextCtrl (& m_DateTimeTextCtrl, 0);
          WA.setValidator (wxDateTimeValidator (& m_DateTime, 
                                                m_StatusMessageTarget, _("some date"),
                                                0));
        }
        {
          WA.setLabel (_("Some &text"));
          WA.setSize (StringTextCtrlSize);
          WA.addTextCtrl (& m_StringTextCtrl, 0);
          WA.setValidator (wxStringValidator (& m_String, 
                                              m_StatusMessageTarget, _("some text"),
                                              4,
                                              0 /*wxStringValidator::IsEmptyAllowed*/));
        }
        WA.popDefaults();

        // WA.skipCell();
        WA.setLabel (_("some text"));
        WA.addAndPushFlexGridSizer (2, false, false);
        {
          // TEST: use string validator based on wxBasictypeValidatorTrait_wxString
          
          wxString ComboStringArray[3] = { "red", "magenta", "cyan" };
          WA.setLabel (_("Some other te&xt"));
          WA.setSize (getAdjustedComboBoxWidth (180), -1);
          WA.addComboBox (& m_AnotherStringComboBox, 
                          3, ComboStringArray);
          WA.setValidator (wxTraitedStringValidator (& m_AnotherString, 
                                                     m_StatusMessageTarget, 
                                                     wxString (_("some other text")),
                                                     5 /* MaxStringLength */,
                                                     0 /* wxTraitedStringValidator::IsEmptyAllowed */
                                                     | wxTraitedStringValidator::IsIgnoreMinimum
                                                     | wxTraitedStringValidator::IsIgnoreMaximum,
                                                     wxString(wxEmptyString)));
        }
        {
          WA.setLabel (_("Some &filename"));
          WA.setSize (StringTextCtrlSize);
          WA.addTextCtrl (& m_SomeFilenameTextCtrl, 0);
          WA.setValidator (wxFilenameValidator (& m_SomeFilenameString, 
                                                m_StatusMessageTarget, 
                                                WA.getFullName(),
                                                0,
                                                wxFilenameValidatorTrait::IsErrorIfInvalid
                                                | wxFilenameValidatorTrait::IsErrorIfNotFile
                                                | wxFilenameValidatorTrait::IsNormalize,
                                                wxString("/bin"),
                                                wxPATH_NORM_ENV_VARS | wxPATH_NORM_DOTS 
                                                /*| wxPATH_NORM_ABSOLUTE */ | wxPATH_NORM_TILDE));
        }
        WA.popSizer();
      }
      WA.popSizer();
      WA.popSizer();

      WA.popOverlay ();

      WA.popSizer();
      WA.popOverlay();
      }
}

void wxStatusValidatorTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
	if (ValidateWithMessageBox (wxID_OK))
	  {
		WxExtLibTest_Integer = m_Integer;
		WxExtLibTest_Double = m_Double;
		WxExtLibTest_AnotherDouble = m_AnotherDouble;
		WxExtLibTest_DateTime = m_DateTime;
		WxExtLibTest_String = m_String;
		WxExtLibTest_AnotherString = m_AnotherString;
		WxExtLibTest_SomeFilenameString = m_SomeFilenameString;
	  }
}

void wxStatusValidatorTestExtDialog::OnCancel(wxCommandEvent& WXUNUSED (Event))
{
    // wxExtDialog::OnCancel (Event);
    EndDialog (wxID_CANCEL);
}

void wxStatusValidatorTestExtDialog::handleWatchedControlChange(wxCommandEvent& Event)
{
    if (Event.GetEventObject() == m_GroupTestDoubleTextCtrl)
      {
        // TEST
#if 0
        testNumberFormat();

        transferDataFromControl (m_GroupTestDoubleTextCtrl);

        wxNumberFormatOptions NumberFormatOptions (2, '.', ';');
        wxString String;
        formatDouble ("%.f", NumberFormatOptions, m_GroupTestDouble, String);

        m_StatusMessageTarget -> setMessage (String, false);
        m_StatusMessageTarget -> display (this);
#endif
      }
}

//=========================================================================
// wxFormatMessageTestExtDialog

BEGIN_EVENT_TABLE (wxFormatMessageTestExtDialog, wxExtDialog)
  // EVT_MENU   (wxID_HELP, wxFormatMessageTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * FormatMessageDescriptionHtmlString;

wxFormatMessageTestExtDialog::wxFormatMessageTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxFormatMessage test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
    setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	m_Parameter1Integer = 42;
	m_Parameter2String = "./some-file.dat";
	m_Parameter3Integer = 2756;
	m_Parameter4Integer = 4096;

	m_FormatString = _T(
"While reading from file \"%{2}\", an error happened (error "
"code \"%1\") - (%3 of %+ Byte read successfully before error \"%1\" "
"was encountered.\n\nAll 14 arguments: %1\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+");

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
    wxSizerAdder PanelSizerAdder (PanelSizer);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, true));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  & PanelSizerAdder,
					  FormatMessageDescriptionHtmlString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder (FlexGridSizer);

	addTextCtrlWithTwoLabels  (& m_Parameter1IntegerTextCtrl, _("Parameter &1"), _("(int)"),
							   wxNumberValidator (& m_Parameter1Integer, 
												  10, 99, 
												  m_StatusMessageTarget, _("parameter 1")),
							   0,
							   wxDefaultSize,
							   & FlexGridSizerAdder);

	wxSize StringTextCtrlSize (getAdjustedTextCtrlWidth (100),
							   getAdjustedTextCtrlHeight (1, true));
	addTextCtrlWithTwoLabels  (& m_Parameter2StringTextCtrl, _("Parameter &2"), _("(path string)"),
							   wxStringValidator (& m_Parameter2String, 
												  m_StatusMessageTarget, _("parameter 2"),
												  80,
												  wxStringValidator::IsEmptyAllowed),
							   0,
							   StringTextCtrlSize,
							   & FlexGridSizerAdder);
	addTextCtrlWithTwoLabels  (& m_Parameter3TextCtrl, _("Parameter &3"), _("(int)"),
							   wxNumberValidator (& m_Parameter3Integer, 
												  0, 1048576, 
												  m_StatusMessageTarget, _("parameter 3")),
							   0,
							   wxDefaultSize,
							   & FlexGridSizerAdder);
	addTextCtrlWithTwoLabels  (& m_Parameter4TextCtrl, _("Parameter &4"), _("(int)"),
							   wxNumberValidator (& m_Parameter4Integer, 
												  0, 1048576, 
												  m_StatusMessageTarget, _("parameter 4")),
							   0,
							   wxDefaultSize,
							   & FlexGridSizerAdder);


	//-------------------------------------------------------------------------
	PanelSizer -> Add (new wxStaticLine (this, -1), 0, 
					   wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder2 (FlexGridSizer);

	wxSize FormatStringTextCtrlSize (getAdjustedTextCtrlWidth (300),
									 getAdjustedTextCtrlHeight (5, true));
	addTextCtrlWithTwoLabels  (& m_Parameter2StringTextCtrl, _("&Format string"), "",
							   wxStringValidator (& m_FormatString, 
												  m_StatusMessageTarget, _("format string"),
												  -1,
												  wxStringValidator::IsEmptyAllowed),
							   wxTE_MULTILINE,
							   FormatStringTextCtrlSize,
							   & FlexGridSizerAdder2);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder3 (FlexGridSizer);

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxFormatMessageTestExtDialog::OnOK), 
			   _("&Evaluate"), & FlexGridSizerAdder3);
    Button->SetDefault();
    addButton (& Button, -1, (wxCommandEventFunction) (& wxFormatMessageTestExtDialog::OnEvaluate14), 
			   _("&Eval. w/14 args"), & FlexGridSizerAdder3);
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxFormatMessageTestExtDialog::OnCancel), 
			   _("Cancel"), & FlexGridSizerAdder3);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (true);
}

void wxFormatMessageTestExtDialog::OnEvaluate14(wxCommandEvent & WXUNUSED(Event))
{
    if (ValidateWithMessageBox ()) // use e.g. wxID_OK to close the dialog
	  {
		wxString ResultString = "The result of the evaluated string:\n\n";

		wxMessageFormatter MessageFormatter (m_FormatString);
		// set up lot's of parameters to be able to test %{N} syntax
		// here, operator% is used to add parameters, and appendTo()
		// will implicitly call format()
		MessageFormatter
		  % m_Parameter1Integer
		  % m_Parameter2String
		  % m_Parameter3Integer
		  % m_Parameter4Integer
		  % "ain't"
		  % "it"
		  % "nice?"
		  % 111
		  % 222
		  % 333
		  % 444.4
		  % wxFormat ("%.2f", 555.5)
		  % 666
		  % 777;
		MessageFormatter.appendTo (ResultString);
		MessageExtDialog (ResultString,
						 wxMessageExtDialog::InformationStyle);
	  }
}

void wxFormatMessageTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
    if (ValidateWithMessageBox ())
	  {
		wxString ResultString = "The result of the evaluated string:\n\n";

		// use wxFormatMessage which is overloaded for (currently) up
		// to five parameters
		ResultString
		  += wxFormatMessage (m_FormatString,
							 m_Parameter1Integer,
							 m_Parameter2String,
							 m_Parameter3Integer,
							 m_Parameter4Integer);

		MessageExtDialog (ResultString,
						 wxMessageExtDialog::InformationStyle);
	  }
}

void wxFormatMessageTestExtDialog::OnCancel(wxCommandEvent & Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================


wxExtLibTestConfigEntryManager WxExtLibTestConfigEntryManager;

wxExtLibTestConfigEntryManager::wxExtLibTestConfigEntryManager()
{
    m_IsInitialized = FALSE;
}

#define M_AddConfigEntry(Variable,ParameterList) \
    { \
	  Variable.init ParameterList; \
      addConfigEntry (& Variable); \
    } \

void wxExtLibTestConfigEntryManager::init ()
{
    if (! m_IsInitialized)
	  {
		// wxIniConfig * Config = new wxIniConfig("WxExtLibTest", "WxExtLibTest", ConfigFilenameString);
		wxFileConfig * Config 
		  = new wxFileConfig ("WxExtLibTest", "WxExtLibTest",
							  ConfigFilenameString, "",
							  wxCONFIG_USE_LOCAL_FILE | wxCONFIG_USE_RELATIVE_PATH);

		wxConfigBase::Set (Config); // ::Set() not really necessary
		setAssociatedConfig (Config);

		//-------------------------------------------------------------------------
		// setup of mapping of config entry objects to keys in the wxConfig is done 
        // here, centralized. Default values and other restrictions (e.g. minmum and
		// maxium of valid integers)  are centralized here too.

#if defined(__WXMSW__)
		const char * DefaultSomePath = "C:\\WxExtLibTest\\SomePath";
#else
		const char * DefaultSomePath = "/WxExtLibTest/SomePath";
#endif
		M_AddConfigEntry (m_SomePathString, 
						  ("/General/SomePath", DefaultSomePath));
		M_AddConfigEntry (m_IsSomeValueEnabled, 
						  ("/Setup/IsSomeValueEnabled", true));
		M_AddConfigEntry (m_IsSomeOtherValueEnabled, 
						  ("/Setup/IsSomeOtherValueEnabled", FALSE));
		M_AddConfigEntry (m_Integer1,
						  ("/Mape/Integer1", 1, 9, 3));
		M_AddConfigEntry (m_Double1,
						  ("/Mape/Double1", 0., 1., 0.5));

		// the sub-structure:
		M_AddConfigEntry (m_Struct1.m_Integer1,
						  ("/Mape/Integer1", 10, 99, 30));
		M_AddConfigEntry (m_Struct1.m_Integer2,
						  ("/Mape/Integer2", 20, 77, 40));
		M_AddConfigEntry (m_Struct1.m_IsSomeValueEnabled, 
						  ("/ADifferentKey/SomeKey", FALSE));

		m_IsInitialized = true;
	  }
}

// being gentlemen :)
#undef M_AddConfigEntry


//=========================================================================
// wxConfigEntryManagerTestExtDialog

BEGIN_EVENT_TABLE (wxConfigEntryManagerTestExtDialog, wxExtDialog)
  //  EVT_MENU   (wxID_HELP, wxConfigEntryManagerTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * ConfigEntryManagerDescriptionHtmlString;

wxConfigEntryManagerTestExtDialog::wxConfigEntryManagerTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxConfigEntryManager test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------

	// set up config entry objects
	WxExtLibTestConfigEntryManager.init ();

	// obtain values (usually from wxConfig)
	// easy and typesafe:
	setValuesToDialog ();

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
    wxSizerAdder PanelSizerAdder (PanelSizer);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, true));
	wxString DescriptionString;
	DescriptionString += "used config path: \"" 
	  + convertAsciiToHtml(ConfigFilenameString) + "\"<br><br>";
	DescriptionString += ConfigEntryManagerDescriptionHtmlString;
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  & PanelSizerAdder,
					  DescriptionString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getHtmlWindow() -> SetBorders (5);
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 2, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder (FlexGridSizer);

	wxSize StringTextCtrlSize (getAdjustedTextCtrlWidth (150),
							   getAdjustedTextCtrlHeight (1, true));
	addTextCtrlWithLabel  (& m_SomePathStringTextCtrl, _("some &path string"),
						   wxStringValidator (& m_SomePathString,
											  m_StatusMessageTarget, _("some path string")),
						   0,
						   StringTextCtrlSize,
						   & FlexGridSizerAdder);
	addCheckBoxWithLabel  (& m_IsSomeValueEnabledCheckBox, _("is some value enabled"),
						   wxGenericValidator (& m_IsSomeValueEnabled),
						   0,
						   & FlexGridSizerAdder);
	addCheckBoxWithLabel  (& m_IsSomeOtherValueEnabledCheckBox, _("is some other value enabled"),
						   wxGenericValidator (& m_IsSomeOtherValueEnabled),
						   0,
						   & FlexGridSizerAdder);
	addTextCtrlWithLabel  (& m_Integer1TextCtrl, _("Integer &1"),
						   wxNumberValidator (& m_Integer1, 
											  1, 9, 
											  m_StatusMessageTarget, _("integer 1")),
						   0,
						   wxDefaultSize,
						   & FlexGridSizerAdder);
	addTextCtrlWithLabel  (& m_Double1TextCtrl, _("Double &1"),
						   wxNumberValidator (& m_Double1, 
											  0., 1., 
											  m_StatusMessageTarget, _("double 1")),
						   0,
						   wxDefaultSize,
						   & FlexGridSizerAdder);
	addTextCtrlWithLabel  (& m_Struct1_Integer1TextCtrl, _("Struct1-Integer &1"),
						   wxNumberValidator (& m_Struct1_Integer1, 
											  10, 99, 
											  m_StatusMessageTarget, _("struct1-integer 1")),
						   0,
						   wxDefaultSize,
						   & FlexGridSizerAdder);
	addTextCtrlWithLabel  (& m_Struct1_Integer1TextCtrl, _("Struct1-Integer &2"),
						   wxNumberValidator (& m_Struct1_Integer2, 
											  20, 77, 
											  m_StatusMessageTarget, _("struct2-integer 1")),
						   0,
						   wxDefaultSize,
						   & FlexGridSizerAdder);
	addCheckBoxWithLabel  (& m_Struct1_IsSomeValueEnabledCheckBox, _("struct1-is some value enabled"),
						   wxGenericValidator (& m_Struct1_IsSomeValueEnabled),
						   0,
						   & FlexGridSizerAdder);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder2 (FlexGridSizer);

	wxButton * Button;
    addButton (& Button, -1, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnRead), 
			   _("&Read"), & FlexGridSizerAdder2);
    addButton (& Button, -1, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnWriteModified), 
			   _("&Write mod."), & FlexGridSizerAdder2);
    Button->SetDefault();
    addButton (& Button, -1, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnSetToDefaults), 
			   _("&Set defaults"), & FlexGridSizerAdder2);
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnCancel), 
			   _("Close"), & FlexGridSizerAdder2);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (true);
}

//-------------------------------------------------------------------------

void wxConfigEntryManagerTestExtDialog::setValuesToDialog()
{
	WxExtLibTestConfigEntryManager.m_SomePathString.get (m_SomePathString);
	WxExtLibTestConfigEntryManager.m_IsSomeValueEnabled.get (m_IsSomeValueEnabled);
	WxExtLibTestConfigEntryManager.m_IsSomeOtherValueEnabled.get (m_IsSomeOtherValueEnabled);
	WxExtLibTestConfigEntryManager.m_Integer1.get (m_Integer1);
	WxExtLibTestConfigEntryManager.m_Double1.get (m_Double1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer1.get (m_Struct1_Integer1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer2.get (m_Struct1_Integer2);
	WxExtLibTestConfigEntryManager.m_Struct1.m_IsSomeValueEnabled.get (m_Struct1_IsSomeValueEnabled);
}

void wxConfigEntryManagerTestExtDialog::setValuesToConfig()
{
	WxExtLibTestConfigEntryManager.m_SomePathString.set (m_SomePathString);
	WxExtLibTestConfigEntryManager.m_IsSomeValueEnabled.set (m_IsSomeValueEnabled);
	WxExtLibTestConfigEntryManager.m_IsSomeOtherValueEnabled.set (m_IsSomeOtherValueEnabled);
	WxExtLibTestConfigEntryManager.m_Integer1.set (m_Integer1);
	WxExtLibTestConfigEntryManager.m_Double1.set (m_Double1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer1.set (m_Struct1_Integer1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer2.set (m_Struct1_Integer2);
	WxExtLibTestConfigEntryManager.m_Struct1.m_IsSomeValueEnabled.set (m_Struct1_IsSomeValueEnabled);
}

//-------------------------------------------------------------------------

void wxConfigEntryManagerTestExtDialog::OnRead(wxCommandEvent & WXUNUSED(Event))
{
    WxExtLibTestConfigEntryManager.readAllConfigEntries ();
	setValuesToDialog ();
	TransferDataToWindow ();
}

void wxConfigEntryManagerTestExtDialog::OnWriteModified(wxCommandEvent & WXUNUSED(Event))
{
    if (ValidateWithMessageBox (-1))
	  {
		setValuesToConfig ();
		WxExtLibTestConfigEntryManager.writeAllConfigEntries ();
	  }
}

void wxConfigEntryManagerTestExtDialog::OnSetToDefaults(wxCommandEvent & WXUNUSED(Event))
{
    WxExtLibTestConfigEntryManager.setDefaultValues ();
	setValuesToDialog ();
	TransferDataToWindow ();
}

void wxConfigEntryManagerTestExtDialog::OnCancel(wxCommandEvent & Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================
// wxTextCtrlSliderPairTestExtDialog

BEGIN_EVENT_TABLE (wxTextCtrlSliderPairTestExtDialog, wxExtDialog)
  //  EVT_MENU   (wxID_HELP, wxTextCtrlSliderPairTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * TextCtrlSliderPairValidatorsDescriptionHtmlString;

long TextCtrlSliderPairTestExtDialog_RedModificationLong = 30;
long TextCtrlSliderPairTestExtDialog_GreenModificationLong = 0;
long TextCtrlSliderPairTestExtDialog_BlueModificationLong = -10;

//-------------------------------------------------------------------------

wxTextCtrlSliderPairTestExtDialog::wxTextCtrlSliderPairTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxTextCtrlSliderPair test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	m_RedModificationLong = TextCtrlSliderPairTestExtDialog_RedModificationLong;
	m_GreenModificationLong = TextCtrlSliderPairTestExtDialog_GreenModificationLong;
	m_BlueModificationLong = TextCtrlSliderPairTestExtDialog_BlueModificationLong;

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
    wxSizerAdder PanelSizerAdder (PanelSizer);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, true));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  & PanelSizerAdder,
					  TextCtrlSliderPairValidatorsDescriptionHtmlString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getHtmlWindow() -> SetBorders (5);
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

	//-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder (FlexGridSizer);

    addTextCtrlSliderPairWithLabel (& m_RedModificationTextCtrl, 
									& m_RedModificationSliderCtrl, _("&Red"),
									& m_RedModificationLong, -100, +100, 
									m_StatusMessageTarget, & FlexGridSizerAdder,
									_("red"));
    addTextCtrlSliderPairWithLabel (& m_GreenModificationTextCtrl, 
									& m_GreenModificationSliderCtrl, _("&Green"),
								    & m_GreenModificationLong, -100, +100, 
									m_StatusMessageTarget, & FlexGridSizerAdder,
									_("green"));
    addTextCtrlSliderPairWithLabel (& m_BlueModificationTextCtrl, 
									& m_BlueModificationSliderCtrl, _("&Blue"),
									& m_BlueModificationLong, -100, +100, 
									m_StatusMessageTarget, & FlexGridSizerAdder,
									_("blue"));

	addWatchedControl (m_RedModificationTextCtrl);
	addWatchedControl (m_GreenModificationTextCtrl);
	addWatchedControl (m_BlueModificationTextCtrl);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));
    wxSizerAdder ButtonSizerAdder (FlexGridSizer);

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxTextCtrlSliderPairTestExtDialog::OnOK), 
			   _("&OK"), & ButtonSizerAdder);
    Button->SetDefault();
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxTextCtrlSliderPairTestExtDialog::OnCancel), 
			   _("Cancel"), & ButtonSizerAdder);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (true);
}

void wxTextCtrlSliderPairTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
	if (ValidateWithMessageBox (wxID_OK))
	  {
	    TextCtrlSliderPairTestExtDialog_RedModificationLong = m_RedModificationLong;
	    TextCtrlSliderPairTestExtDialog_GreenModificationLong = m_GreenModificationLong;
	    TextCtrlSliderPairTestExtDialog_BlueModificationLong = m_BlueModificationLong;
	  }
}

void wxTextCtrlSliderPairTestExtDialog::OnCancel(wxCommandEvent& Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================
// wxDialogZoomTestExtDialog

BEGIN_EVENT_TABLE (wxDialogZoomTestExtDialog, wxExtDialog)
  //  EVT_MENU   (wxID_HELP, wxDialogZoomTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxDialogZoomTestExtDialog::wxDialogZoomTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxExtDialog dialog zoom test"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	m_DialogZoom = wxExtDialog::getGlobalDialogZoom ();

	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
    wxSizerAdder PanelSizerAdder (PanelSizer);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, true));
	wxString DescriptionString = 
	  (_T("<b>dialog zoom support:</b><br><br>\n\n"
		  "Specify a zooming factor of 2 if your display's resolution "
		  "is 2560 x 1920 pixel ;-) "));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  & PanelSizerAdder,
					  DescriptionString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getHtmlWindow() -> SetBorders (5);
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 2, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));
    wxSizerAdder FlexGridSizerAdder (FlexGridSizer);

	addTextCtrlWithLabel  (& m_DialogZoomTextCtrl, _("Dialog &zoom"),
						   wxNumberValidator (& m_DialogZoom, 
											  0.25, 2.0, 
											  m_StatusMessageTarget, _("dialog zoom"),
											  0, "%.2f"),
						   0,
						   wxDefaultSize,
						   & FlexGridSizerAdder);
	addTextCtrlWithLabel  (& m_BorderCompressionTextCtrl, _("Border &compression"),
						   wxNumberValidator (& BorderCompressionValue, 
											  0.25, 1., 
											  m_StatusMessageTarget, _("border compression"),
											  0, "%.2f"),
						   0,
						   wxDefaultSize,
						   & FlexGridSizerAdder);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));
    wxSizerAdder ButtonSizerAdder (FlexGridSizer);

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxDialogZoomTestExtDialog::OnOK), 
			   _("&Set"), & ButtonSizerAdder);
    Button->SetDefault();
    addButton (& Button, wxID_CANCEL, NULL, //(wxCommandEventFunction) (& wxDialogZoomTestExtDialog::OnCancel), 
			   _("Close"), & ButtonSizerAdder);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (true);
}

//-------------------------------------------------------------------------

void wxDialogZoomTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
	if (ValidateWithMessageBox (wxID_OK))
	  {
		wxExtDialog::setGlobalDialogZoom (m_DialogZoom);
	  }
}

//=========================================================================
// WxExtLibTestApp

IMPLEMENT_APP(WxExtLibTestApp)

bool WxExtLibTestApp::OnInit()
{
    m_IsAppInitialized = false;
    m_WxExtLibTestFrame = NULL;

    wxMessageExtDialog::setGlobalTitlePostfix ("WxExtLibTest");
    wxMessageExtDialog::setGlobalFlags (wxMessageExtDialog::DisplayImage);

	m_Locale = NULL;
	((WxExtLibTestApp *) wxTheApp) -> updateLanguageSettings ();

#if (M_WxExtLib_IsUseStxLogging == 1)
    // TEST
    stxSetupLogging ("WxExtLibTest.log");
    stxSetupLogFlush (true);
#endif

    wxImage::AddHandler(new wxPNGHandler);

#ifndef M_IsUseChmHelpController
#if wxUSE_HTML
#if wxUSE_GIF
    // Required for images in the online documentation
    wxImage::AddHandler(new wxGIFHandler);
#endif
    // Required for advanced HTML help
#if wxUSE_STREAMS && wxUSE_ZIPSTREAM && wxUSE_ZLIB
    wxFileSystem::AddHandler(new wxZipFSHandler);
#endif
#endif
#endif

    wxAppRootFrame * AppRootFrame = NULL;
#if (M_WxExtLib_IsUseAppRootFrame == 1)
    AppRootFrame = wxAppRootFrame::create (wxICON (::WxExtLibTest));
#endif
    WxExtLibTestFrame * FrameWindow = new WxExtLibTestFrame(AppRootFrame, 
                                                            _T("WxExtLibTest Application"),
                                                            wxPoint(50, 50), wxSize(450, 340),
                                                            wxDEFAULT_FRAME_STYLE);

#if (M_WxExtLib_IsUseAppRootFrame == 1)
    wxAppRootFrame::setup (FrameWindow);
#endif

    if (AppRootFrame != NULL)
      {
        FrameWindow -> accessNonModalDialogManag().setParentWindow (AppRootFrame);
      }
    else
      {
        FrameWindow -> accessNonModalDialogManag().setParentWindow (FrameWindow);
      }

    FrameWindow -> Show (true);
    m_WxExtLibTestFrame = FrameWindow;

#ifdef M_IsUseChmHelpController
    if (!FrameWindow -> m_ChmHelpController.Initialize (_T("MyTestDoc")))
      {
        wxLogError (wxT("Cannot initialize chm help controller."));
      }
#else
    if (!FrameWindow -> m_HtmlHelpController.Initialize (_T("MyTestDoc")))
      {
        wxLogError (wxT("Cannot initialize html help controller."));
      }
#endif

    m_IsAppInitialized = true;
    return true;
}

void WxExtLibTestApp::updateLanguageSettings ()
{
    delete m_Locale;
	m_Locale = NULL;

	m_Locale = new wxLocale;

	int LanguageIndex = 3;
	switch (LanguageIndex)
	  {
	  case 1:
		m_Locale -> Init (wxLANGUAGE_FRENCH);
		break;
	  case 2:
		m_Locale -> Init (wxLANGUAGE_GERMAN);
		break;
	  case 3:
		m_Locale -> Init (wxLANGUAGE_DEFAULT);
		break;
	  case 0:
	  default:
		m_Locale -> Init (wxLANGUAGE_ENGLISH_UK);
	  }

    wxCatalogAddManag CatalogAddManag;
    CatalogAddManag.setLocale (m_Locale);
    CatalogAddManag.addCatalogWithVersionCheck ("WxExtLib", 
                                                M_WxExtLib_VersionIdentString /* "0.82.0003" */);
    // CatalogAddManag.addCatalogWithVersionCheck ("WxExtLibTest", "0.82.0003");
    CatalogAddManag.addCatalogWithVersionCheck ("WxExtLibTest",
                                                M_WxExtLib_VersionIdentString /* "0.82.0008" */);
    CatalogAddManag.addCatalogWithVersionCheck ("NotFoundCatalog", "0.82.0005");
    wxString MessageString;
    if (CatalogAddManag.getMessage (MessageString))
      {
        MessageExtDialog (MessageString, wxMessageExtDialog::WarningStyle);
      }
}

void WxExtLibTestApp::SetActive (bool IsActive, wxWindow * LastFocus)
{
    wxApp::SetActive (IsActive, LastFocus);
    if (wxGetGlobalAppRootFrame() != NULL)
      {
#if (M_WxExtLib_IsUseAppRootFrame == 1)
        wxGetGlobalAppRootFrame() -> notifyActivateAppEvent (IsActive, LastFocus);
#endif
      }
}

//=========================================================================
// WxExtLibTestFrame

BEGIN_EVENT_TABLE(WxExtLibTestFrame, WxExtLibTestBase)
    EVT_QUERY_END_SESSION (WxExtLibTestFrame::OnCloseEvent)
    EVT_END_SESSION (WxExtLibTestFrame::OnCloseEvent)
    EVT_CLOSE (WxExtLibTestFrame::OnCloseEvent)

    EVT_MENU(ID_Quit,  WxExtLibTestFrame::OnQuit)

    EVT_MENU(ID_MessageExtDialogTest, WxExtLibTestFrame::OnMessageExtDialogTest)
    EVT_MENU(ID_StatusValidatorTestDialog, WxExtLibTestFrame::OnStatusValidatorTestDialog)
    EVT_MENU(ID_FormatMessageTestDialog, WxExtLibTestFrame::OnMessageFormatterTest)
    EVT_MENU(ID_ConfigEntryManagerTestDialog, WxExtLibTestFrame::OnConfigEntryManagerTestDialog)
    EVT_MENU(ID_TextCtrlSliderPairTestDialog, WxExtLibTestFrame::OnTextCtrlSliderPairTestDialog)
    EVT_MENU(ID_DialogZoomTestDialog, WxExtLibTestFrame::OnDialogZoomTestDialog)

    EVT_MENU(ID_NonModalDialog1,  WxExtLibTestFrame::OnNonModalDialog1)
    EVT_MENU(ID_NonModalDialog2,  WxExtLibTestFrame::OnNonModalDialog2)
    EVT_MENU(ID_NonModalDialog3,  WxExtLibTestFrame::OnNonModalDialog3)

    EVT_MENU(ID_Help, WxExtLibTestFrame::OnHelp)
    EVT_MENU(ID_About, WxExtLibTestFrame::OnAbout)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

WxExtLibTestFrame::WxExtLibTestFrame(wxWindow * ParentWindow, 
                                     const wxString& title, const wxPoint& pos, const wxSize& size, long style)
    : WxExtLibTestBase(ParentWindow, -1, title, pos, size, style)
{ 
    // set the frame icon
    SetIcon (wxICON (::WxExtLibTest));

    // m_NonModalDialogManag.setFrame (this);

    // create the menu bar
    wxMenu *FileMenu = new wxMenu;
    FileMenu->Append(ID_MessageExtDialogTest, _T("&wxMessageExtDialog test..."));
    FileMenu->Append(ID_StatusValidatorTestDialog, _T("S&tatusValidators test dialog..."));
    FileMenu->Append(ID_FormatMessageTestDialog, _T("wx&FormatMessage test dialog..."));
    FileMenu->Append(ID_ConfigEntryManagerTestDialog, _T("wx&ConfigEntryManager test dialog..."));
    FileMenu->Append(ID_TextCtrlSliderPairTestDialog, _T("wxTextCtrl/wx&Slider pair test dialog..."));
    FileMenu->Append(ID_DialogZoomTestDialog, _T("Dialog &zoom test..."));
	FileMenu->AppendSeparator ();
    FileMenu->Append(ID_Quit, _T("E&xit\tAlt-X"), _T("Quit this program"));

    // create the menu bar
    wxMenu *NonModalTestMenu = new wxMenu;
    NonModalTestMenu->Append(ID_NonModalDialog1, _T("Non-modal dialog &1..."));
    NonModalTestMenu->Append(ID_NonModalDialog2, _T("Non-modal dialog &2..."));
    NonModalTestMenu->Append(ID_NonModalDialog3, _T("Non-modal dialog &3..."));

    wxMenu *HelpMenu = new wxMenu;
    HelpMenu->Append(ID_Help, _T("&Help...\tF1"), _T("Show help"));
    HelpMenu->Append(ID_About, _T("&About..."), _T("Show about dialog"));

    wxMenuBar *MenuBar = new wxMenuBar();
    MenuBar->Append(FileMenu, _T("&File"));
    MenuBar->Append(NonModalTestMenu, _T("&Non-Modal Test"));
    MenuBar->Append(HelpMenu, _T("&Help"));

    SetMenuBar(MenuBar);

    CreateStatusBar(2);

	// wxExtDialog::setGlobalDesktopReferenceSize (wxSize (900, 700));

    WxExtLibTest_DateTime.SetToCurrent();
}

//-------------------------------------------------------------------------

extern const char * MessageExtDialogDescription;

void WxExtLibTestFrame::OnMessageExtDialogTest(wxCommandEvent& WXUNUSED(Event))
{
    // WARN don't know if _T must be around each of the string parts 
    wxMessageExtDialog SomeMessageExtDialog (NULL, 
											 MessageExtDialogDescription,
										  _T("extended message box test"));
	SomeMessageExtDialog.setStyle (wxMessageExtDialog::QuestionStyle);
	const int NoNoButtonIdent = SomeMessageExtDialog.addButton ("&No no");
	/* const int JumpButtonIdent = */ SomeMessageExtDialog.addButton ("&Jump");
	SomeMessageExtDialog.makeLastAddedButtonDefault ();
	SomeMessageExtDialog.addButton ("&Cancel", wxID_CANCEL);
	int ReturnedButtonIdent = SomeMessageExtDialog.ShowModal ();
 	if (ReturnedButtonIdent == NoNoButtonIdent)
 	  {
 		// easiest case: a message box with only an 'OK' button can
 		// be created and displayed with a single function call:
		MessageExtDialog (_T("An <b>error</b> message is hanging around!"),
 						 wxMessageExtDialog::ErrorStyle | wxMessageExtDialog::IsHtmlMode);

		wxMessageExtDialog OtherMessageExtDialog (NULL, 
											  _T("Please decide"),
											  _T(""));
		OtherMessageExtDialog.setStyle (wxMessageExtDialog::CriticalErrorStyle);
		const int FirstButtonIdent = OtherMessageExtDialog.addButton ("&Fast");
		const int SecondButtonIdent = OtherMessageExtDialog.addButton ("&Small");
		const int ThirdButtonIdent = OtherMessageExtDialog.addButton ("&Fast'n'small");
		OtherMessageExtDialog.makeLastAddedButtonDefault ();
		int OtherReturnedButtonIdent = OtherMessageExtDialog.ShowModal ();

#if wxCHECK_VERSION(2,5,3)
        // at some point before 2.5.3 wxUnusedVar was added
        wxUnusedVar (FirstButtonIdent);
        wxUnusedVar (SecondButtonIdent);
        wxUnusedVar (ThirdButtonIdent);
        wxUnusedVar (OtherReturnedButtonIdent);
#endif
 	  }

}

void WxExtLibTestFrame::OnStatusValidatorTestDialog(wxCommandEvent& WXUNUSED(Event))
{
    wxStatusValidatorTestExtDialog StatusValidatorTestExtDialog (this);
	StatusValidatorTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnMessageFormatterTest (wxCommandEvent& WXUNUSED(Event))
{
    wxFormatMessageTestExtDialog FormatMessageTestExtDialog (this);
	FormatMessageTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnConfigEntryManagerTestDialog (wxCommandEvent& WXUNUSED(Event))
{
    wxConfigEntryManagerTestExtDialog ConfigEntryManagerTestExtDialog (this);
	ConfigEntryManagerTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnTextCtrlSliderPairTestDialog(wxCommandEvent& WXUNUSED(Event))
{
    wxTextCtrlSliderPairTestExtDialog TextCtrlSliderPairTestExtDialog (this);
	TextCtrlSliderPairTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnDialogZoomTestDialog (wxCommandEvent& WXUNUSED(Event))
{
    int ResultCode = wxID_CANCEL;
    do 
	  {
		wxDialogZoomTestExtDialog DialogZoomTestExtDialog (this);
		ResultCode = DialogZoomTestExtDialog.ShowModal ();
	  }
	while (ResultCode == wxID_OK);
}

//-------------------------------------------------------------------------

void WxExtLibTestFrame::OnQuit(wxCommandEvent& WXUNUSED(Event))
{
    Close (true);
}

//-------------------------------------------------------------------------

void WxExtLibTestFrame::OnCloseEvent (wxCloseEvent & CloseEvent)
{
    // handleCloseEvent (CloseEvent);
    m_NonModalDialogManag.closeAll();

    if (CloseEvent.GetVeto())
      return;

    if (wxGetGlobalAppRootFrame() != NULL)
      wxGetGlobalAppRootFrame() -> Close();

    CloseEvent.Skip();
}

//-------------------------------------------------------------------------

void WxExtLibTestFrame::OnNonModalDialog1 (wxCommandEvent & WXUNUSED(Event))
{
    m_NonModalDialogManag.handleMenuCommand (ID_NonModalDialog1);
}

void WxExtLibTestFrame::OnNonModalDialog2 (wxCommandEvent & WXUNUSED(Event))
{
    m_NonModalDialogManag.handleMenuCommand (ID_NonModalDialog2);
}

void WxExtLibTestFrame::OnNonModalDialog3 (wxCommandEvent & WXUNUSED(Event))
{
    m_NonModalDialogManag.handleMenuCommand (ID_NonModalDialog3);
}

void WxExtLibTestFrame::OnAbout(wxCommandEvent& WXUNUSED(Event))
{
    MessageExtDialog (& getApp().getFrame(),
                      _T("<font size=\"+2\"><b>WxExtLibTest</b></font><br><br>\n\n"
                         "<i>Sample program to demonstrate some features of the WxWidgetsExtensions "
                         "(WxExtLib) library and how to use them.</i>"
                         "<br><br>"
                         "Version: " M_WxExtLib_VersionIdentString " (" M_WxExtLib_DateIdentString "), "
                         "config: " M_WxExtLib_ConfigTagString
                         "<br><br>"
                         "Copyright (C) 2004-2007 by Daniel Kps.<br>\n"
                         "WxExtLib is distributed under a Zlib-like open source license."
                         ), 
                      wxEmptyString,
                      wxMessageExtDialog::InformationStyle | wxMessageExtDialog::IsHtmlMode);


}

void WxExtLibTestFrame::OnHelp(wxCommandEvent& WXUNUSED(Event))
{
#ifdef M_IsUseChmHelpController
    // m_ChmHelpController.DisplayContents ();
    m_ChmHelpController.DisplaySection ("Classes");
#else
    // m_HtmlHelpController.DisplayContents ();
    m_HtmlHelpController.DisplaySection ("Classes");
#endif
}

//=========================================================================
