// -*- c++ -*-
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxExtLib (WxWidgetsExtensions) library
-----------------------------

COPYRIGHT NOTICE:

WxExtLib library Copyright (c) 2006-2007 Daniel Kps

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxExtLib library Copyright Notice
*/

//-------------------------------------------------------------------------

//=========================================================================
// WxExtLib config header proxy
//=========================================================================

#ifndef _INCLUDED_WxExtLibConfig_h
#define _INCLUDED_WxExtLibConfig_h

//-------------------------------------------------------------------------
// first include header which contains preprocessor settings/defines

#if (defined M_WxExtLib_IsUseDefaultSetupHeader)

    // WxExtLibConfig_Setup.h is usually contained in WxExtLib source
    // directory (./src) and contains a default setup
#   include <WxExtLibConfig_Setup.h>

#elif (defined M_WxExtLib_AlternativeConfigFilename)

    // NOTE include with filename being a macro may be supported only
    // by new C/C++ compilers/cpp
#   include M_WxExtLib_AlternativeConfigFilename

#elif (defined M_WxExtLib_IsUseWxExtLibLocalSetupHeader)

    // WxExtLibConfig_Setup.h is usually contained in WxExtLib source
    // directory (./src) and contains a default setup
#   include <WxExtLibConfig_Setup.local.h>

#else

    // include some file for project-specific configuration
    // (the filename may need to be added to list of searched
    // include directories)
#   include <project_config.local.h>
// #   include "project_config.local.h"

#endif

//-------------------------------------------------------------------------
// include header to do automatic setup (partially based on desired setup 
// e.g. from config settings/define header)

#include <WxExtLibConfig_Auto.h>

//=========================================================================

#if (M_WxExtLib_IsIncludeStdafxHeader)

    // inclusion of "Stdafx.h" header first may be required if using MFC
    // and precompiled headers with VC++
#   include "Stdafx.h"

#endif

//-------------------------------------------------------------------------

#endif

