//-------------------------------------------------------------------------
// Licence:     wxWindows licence
//-------------------------------------------------------------------------

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

// the application icon (under Windows and OS/2 it is in resources)
#if defined(__WXGTK__) || defined(__WXMOTIF__) || defined(__WXMAC__) || defined(__WXMGL__) || defined(__WXX11__)
    #include "WxExtLibTest.xpm"
#endif

#include "WxExtDialog.h"
#include "MessageExtDialog.h"
#include "WxMisc.h"
#include <wx/statline.h>

//-------------------------------------------------------------------------

#include "ConfigEntry.h"
#include <wx/fileconf.h>
// #if defined(__WXMSW__)
// #   include <wx/msw/regconf.h>
// #   include <wx/msw/iniconf.h>
// #endif

#if defined(__WXMSW__)
const char * ConfigFilenameString = ".\\WxExtLibTest.ini";
#else
const char * ConfigFilenameString = "./WxExtLibTest.ini";
#endif

//=========================================================================

double BorderCompressionValue = 1.;

//-------------------------------------------------------------------------

class WxExtLibTestApp : public wxApp
{
public:
    virtual bool OnInit();

    void updateLanguageSettings ();

private:
	wxLocale * m_Locale;
};

class WxExtLibTestFrame : public wxFrame
{
public:
    WxExtLibTestFrame (const wxString& title, const wxPoint& pos, const wxSize& size,
             long style = wxDEFAULT_FRAME_STYLE);

    void OnMessageExtDialogTest (wxCommandEvent& Event);
    void OnNumberValidatorTestDialog (wxCommandEvent& Event);
    void OnMessageFormatterTest (wxCommandEvent& Event);
    void OnConfigEntryManagerTestDialog (wxCommandEvent& Event);
    void OnTextCtrlSliderPairTestDialog (wxCommandEvent& Event);
    void OnDialogZoomTestDialog (wxCommandEvent& Event);
    void OnQuit (wxCommandEvent& Event);

    void OnAbout (wxCommandEvent& Event);

private:
    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxStatusValidatorsTestExtDialog: public wxExtDialog
{
public:
    wxStatusValidatorsTestExtDialog (wxWindow * ParentWindow);

	virtual void OnOK(wxCommandEvent& Event);
	virtual void OnCancel(wxCommandEvent& Event);

private:

    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_IntegerTextCtrl;
    wxTextCtrl * m_DoubleTextCtrl;
    wxTextCtrl * m_DateTimeTextCtrl;
    wxTextCtrl * m_StringTextCtrl;

    int m_Integer;
    double m_Double;
    wxDateTime m_DateTime;
    wxString m_String;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxFormatMessageTestExtDialog: public wxExtDialog
{
public:
    wxFormatMessageTestExtDialog (wxWindow * ParentWindow);

	virtual void OnOK(wxCommandEvent& Event);
	virtual void OnEvaluate14(wxCommandEvent& Event);
	virtual void OnCancel(wxCommandEvent& Event);

private:

    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_Parameter1IntegerTextCtrl;
    wxTextCtrl * m_Parameter2StringTextCtrl;
    wxTextCtrl * m_Parameter3TextCtrl;
    wxTextCtrl * m_Parameter4TextCtrl;

    wxTextCtrl * m_FormatStringTextCtrl;

    int m_Parameter1Integer;
    wxString m_Parameter2String;
    int m_Parameter3Integer;
    int m_Parameter4Integer;

    wxString m_FormatString;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxExtLibTestConfigEntryManager : public wxConfigEntryManager
{
  public:
    wxExtLibTestConfigEntryManager ();
    void init ();

  public:
    wxStringConfigEntry  m_SomePathString;
    wxBooleanConfigEntry m_IsSomeValueEnabled;
    wxBooleanConfigEntry m_IsSomeOtherValueEnabled;
    wxIntegerConfigEntry m_Integer1;

    // it is possible to put wxConfigEntry objects in a sub-structure to
    // avoid very long variable identifiers or to re-use the same
    // identifier
    struct tag_Struct1
	{
	  wxIntegerConfigEntry m_Integer1;
	  wxIntegerConfigEntry m_Integer2;
	  wxBooleanConfigEntry m_IsSomeValueEnabled;
	} m_Struct1;

  private:
    bool m_IsInitialized;
};

extern wxExtLibTestConfigEntryManager WxExtLibTestConfigEntryManager;

//-------------------------------------------------------------------------

class wxConfigEntryManagerTestExtDialog: public wxExtDialog
{
public:
    wxConfigEntryManagerTestExtDialog (wxWindow * ParentWindow);

	virtual void OnRead (wxCommandEvent& Event);
	virtual void OnWriteModified (wxCommandEvent& Event);
	virtual void OnSetToDefaults (wxCommandEvent& Event);
	virtual void OnCancel (wxCommandEvent& Event);

    void setValuesToDialog();
    void setValuesToConfig();

private:
    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_SomePathStringTextCtrl;
    wxCheckBox * m_IsSomeValueEnabledCheckBox;
    wxCheckBox * m_IsSomeOtherValueEnabledCheckBox;
    wxTextCtrl * m_Integer1TextCtrl;
    wxTextCtrl * m_Struct1_Integer1TextCtrl;
    wxTextCtrl * m_Struct1_Integer2TextCtrl;
    wxCheckBox * m_Struct1_IsSomeValueEnabledCheckBox;

    wxString m_SomePathString;
    bool m_IsSomeValueEnabled;
    bool m_IsSomeOtherValueEnabled;
    int m_Integer1;
    int m_Struct1_Integer1;
    int m_Struct1_Integer2;
    bool m_Struct1_IsSomeValueEnabled;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxTextCtrlSliderPairTestExtDialog: public wxExtDialog
{
public:
    wxTextCtrlSliderPairTestExtDialog (wxWindow * ParentWindow);

	virtual void OnOK(wxCommandEvent& Event);
	virtual void OnCancel(wxCommandEvent& Event);

private:

    wxMultiLineText m_DescriptionMultiLineText;

    wxTextCtrl * m_RedModificationTextCtrl;
    wxSlider * m_RedModificationSliderCtrl;
    wxTextCtrl * m_GreenModificationTextCtrl;
    wxSlider * m_GreenModificationSliderCtrl;
    wxTextCtrl * m_BlueModificationTextCtrl;
    wxSlider * m_BlueModificationSliderCtrl;

	long m_RedModificationLong;
	long m_GreenModificationLong;
	long m_BlueModificationLong;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

class wxDialogZoomTestExtDialog: public wxExtDialog
{
public:
    wxDialogZoomTestExtDialog (wxWindow * ParentWindow);

    virtual void OnOK (wxCommandEvent& Event);

private:
    wxMultiLineText m_DescriptionMultiLineText;

    double m_DialogZoom;

    wxTextCtrl * m_DialogZoomTextCtrl;
    wxTextCtrl * m_BorderCompressionTextCtrl;

    DECLARE_EVENT_TABLE()
};

//=========================================================================

// IDs for the controls and the menu commands
enum
{
    // menu items
    ID_Quit = 1,

    // special id for about menu entry:
    ID_About = wxID_ABOUT,

	ID_MessageExtDialogTest = 33000,
	ID_NumberValidatorTestDialog,
	ID_FormatMessageTestDialog,
	ID_ConfigEntryManagerTestDialog,
	ID_TextCtrlSliderPairTestDialog,
	ID_DialogZoomTestDialog
};

//----------------------------------------------------------------------------
// wxStatusValidatorsTestExtDialog

BEGIN_EVENT_TABLE (wxStatusValidatorsTestExtDialog, wxExtDialog)
  // EVT_MENU   (wxID_HELP, wxStatusValidatorsTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * StatusValidatorsDescriptionHtmlString;

int WxExtLibTest_Integer = 42;
double WxExtLibTest_Double = 8.12;
wxDateTime WxExtLibTest_DateTime;
wxString WxExtLibTest_String = "abcd";

//-------------------------------------------------------------------------

wxStatusValidatorsTestExtDialog::wxStatusValidatorsTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("StatusValidators test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	// initilize values
	m_Integer = WxExtLibTest_Integer;
	m_Double = WxExtLibTest_Double;
	m_DateTime = WxExtLibTest_DateTime;
	m_String = WxExtLibTest_String;

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, TRUE));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  PanelSizer,
					  StatusValidatorsDescriptionHtmlString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	addTextCtrlWithTwoLabels  (& m_IntegerTextCtrl, _("Some &integer number"), _(""),
							   wxNumberValidator (& m_Integer, 
												  10, 99, 
												  m_StatusMessageTarget, _("some integer number")),
							   0,
							   wxDefaultSize,
							   FlexGridSizer);
	addTextCtrlWithTwoLabels  (& m_IntegerTextCtrl, _("Some &double number"), _(""),
							   wxNumberValidator (& m_Double, 
												  4.4, 55.2327, 
												  m_StatusMessageTarget, _("some double number"),
												  wxNumberValidator::IsEmptyAllowed,
												  "%.2f"),
							   0,
							   wxDefaultSize,
							   FlexGridSizer);

	wxSize DateTimeTextCtrlSize (getAdjustedTextCtrlWidth (140),
								 getAdjustedTextCtrlHeight (1, TRUE));
	addTextCtrlWithTwoLabels  (& m_DateTimeTextCtrl, _("Some da&te"), _(""),
							   wxDateTimeValidator (& m_DateTime, 
													m_StatusMessageTarget, _("some date"),
													0),
							   0,
							   DateTimeTextCtrlSize,
							   FlexGridSizer);
	wxSize StringTextCtrlSize (getAdjustedTextCtrlWidth (100),
							   getAdjustedTextCtrlHeight (1, TRUE));
	addTextCtrlWithTwoLabels  (& m_StringTextCtrl, _("Some &text"), _(""),
							   wxStringValidator (& m_String, 
												  m_StatusMessageTarget, _("some text"),
												  4,
												  wxStringValidator::IsEmptyAllowed),
							   0,
							   StringTextCtrlSize,
							   FlexGridSizer);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxStatusValidatorsTestExtDialog::OnOK), 
			   _("&OK"), FlexGridSizer);
    Button->SetDefault();
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxStatusValidatorsTestExtDialog::OnCancel), 
			   _("Cancel"), FlexGridSizer);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (TRUE);
}

void wxStatusValidatorsTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
	if (ValidateWithMessageBox (wxID_OK))
	  {
		WxExtLibTest_Integer = m_Integer;
		WxExtLibTest_Double = m_Double;
		WxExtLibTest_DateTime = m_DateTime;
		WxExtLibTest_String = m_String;
	  }
}

void wxStatusValidatorsTestExtDialog::OnCancel(wxCommandEvent& Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================
// wxFormatMessageTestExtDialog

BEGIN_EVENT_TABLE (wxFormatMessageTestExtDialog, wxExtDialog)
  // EVT_MENU   (wxID_HELP, wxFormatMessageTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * FormatMessageDescriptionHtmlString;

wxFormatMessageTestExtDialog::wxFormatMessageTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxFormatMessage test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	m_Parameter1Integer = 42;
	m_Parameter2String = "./some-file.dat";
	m_Parameter3Integer = 2756;
	m_Parameter4Integer = 4096;

	m_FormatString = _T(
"While reading from file \"%{2}\", an error happened (error "
"code \"%1\") - (%3 of %+ Byte read successfully before error \"%1\" "
"was encountered.\n\nAll 14 arguments: %1\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+\n%+");

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, TRUE));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  PanelSizer,
					  FormatMessageDescriptionHtmlString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	addTextCtrlWithTwoLabels  (& m_Parameter1IntegerTextCtrl, _("Parameter &1"), _("(int)"),
							   wxNumberValidator (& m_Parameter1Integer, 
												  10, 99, 
												  m_StatusMessageTarget, _("parameter 1")),
							   0,
							   wxDefaultSize,
							   FlexGridSizer);

	wxSize StringTextCtrlSize (getAdjustedTextCtrlWidth (100),
							   getAdjustedTextCtrlHeight (1, TRUE));
	addTextCtrlWithTwoLabels  (& m_Parameter2StringTextCtrl, _("Parameter &2"), _("(path string)"),
							   wxStringValidator (& m_Parameter2String, 
												  m_StatusMessageTarget, _("parameter 2"),
												  80,
												  wxStringValidator::IsEmptyAllowed),
							   0,
							   StringTextCtrlSize,
							   FlexGridSizer);
	addTextCtrlWithTwoLabels  (& m_Parameter3TextCtrl, _("Parameter &3"), _("(int)"),
							   wxNumberValidator (& m_Parameter3Integer, 
												  0, 1048576, 
												  m_StatusMessageTarget, _("parameter 3")),
							   0,
							   wxDefaultSize,
							   FlexGridSizer);
	addTextCtrlWithTwoLabels  (& m_Parameter4TextCtrl, _("Parameter &4"), _("(int)"),
							   wxNumberValidator (& m_Parameter4Integer, 
												  0, 1048576, 
												  m_StatusMessageTarget, _("parameter 4")),
							   0,
							   wxDefaultSize,
							   FlexGridSizer);


	//-------------------------------------------------------------------------
	PanelSizer -> Add (new wxStaticLine (this, -1), 0, 
					   wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	wxSize FormatStringTextCtrlSize (getAdjustedTextCtrlWidth (300),
									 getAdjustedTextCtrlHeight (3, TRUE));
	addTextCtrlWithTwoLabels  (& m_Parameter2StringTextCtrl, _("&Format string"), _(""),
							   wxStringValidator (& m_FormatString, 
												  m_StatusMessageTarget, _("format string"),
												  -1,
												  wxStringValidator::IsEmptyAllowed),
							   wxTE_MULTILINE,
							   FormatStringTextCtrlSize,
							   FlexGridSizer);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxFormatMessageTestExtDialog::OnOK), 
			   _("&Evaluate"), FlexGridSizer);
    Button->SetDefault();
    addButton (& Button, -1, (wxCommandEventFunction) (& wxFormatMessageTestExtDialog::OnEvaluate14), 
			   _("&Eval. w/14 args"), FlexGridSizer);
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxFormatMessageTestExtDialog::OnCancel), 
			   _("Cancel"), FlexGridSizer);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (TRUE);
}

void wxFormatMessageTestExtDialog::OnEvaluate14(wxCommandEvent & WXUNUSED(Event))
{
    if (ValidateWithMessageBox ()) // use e.g. wxID_OK to close the dialog
	  {
		wxString ResultString = "The result of the evaluated string:\n\n";

		wxMessageFormatter MessageFormatter (m_FormatString);
		// set up lot's of parameters to be able to test %{N} syntax
		// here, operator% is used to add parameters, and appendTo()
		// will implicitly call format()
		MessageFormatter
		  % m_Parameter1Integer
		  % m_Parameter2String
		  % m_Parameter3Integer
		  % m_Parameter4Integer
		  % "ain't"
		  % "it"
		  % "nice?"
		  % 111
		  % 222
		  % 333
		  % 444.4
		  % wxFormat ("%.2f", 555.5)
		  % 666
		  % 777;
		MessageFormatter.appendTo (ResultString);
		MessageExtDialog (ResultString,
						 wxMessageExtDialog::InformationStyle);
	  }
}

void wxFormatMessageTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
    if (ValidateWithMessageBox ())
	  {
		wxString ResultString = "The result of the evaluated string:\n\n";

		// use wxFormatMessage which is overloaded for (currently) up
		// to five parameters
		ResultString
		  += wxFormatMessage (m_FormatString,
							 m_Parameter1Integer,
							 m_Parameter2String,
							 m_Parameter3Integer,
							 m_Parameter4Integer);

		MessageExtDialog (ResultString,
						 wxMessageExtDialog::InformationStyle);
	  }
}

void wxFormatMessageTestExtDialog::OnCancel(wxCommandEvent& Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================


wxExtLibTestConfigEntryManager WxExtLibTestConfigEntryManager;

wxExtLibTestConfigEntryManager::wxExtLibTestConfigEntryManager()
{
    m_IsInitialized = FALSE;
}

#define M_AddConfigEntry(Variable,ParameterList) \
    { \
	  Variable.init ParameterList; \
      addConfigEntry (& Variable); \
    } \

void wxExtLibTestConfigEntryManager::init ()
{
    if (! m_IsInitialized)
	  {
		// wxIniConfig * Config = new wxIniConfig("WxExtLibTest", "WxExtLibTest", ConfigFilenameString);
		wxFileConfig * Config 
		  = new wxFileConfig ("WxExtLibTest", "WxExtLibTest",
							  ConfigFilenameString, "",
							  wxCONFIG_USE_LOCAL_FILE | wxCONFIG_USE_RELATIVE_PATH);

		wxConfigBase::Set (Config); // ::Set() not really necessary
		setAssociatedConfig (Config);

		//-------------------------------------------------------------------------
		// Mapping of config entry objects to keys in the wxConfig is done here,
		// centralized. Default values and other restrictions (e.g. minmum and
		// maxium of valid integers)  are centralized here too.

#if defined(__WXMSW__)
		const char * DefaultSomePath = "C:\\WxExtLibTest\\SomePath";
#else
		const char * DefaultSomePath = "/WxExtLibTest/SomePath";
#endif
		M_AddConfigEntry (m_SomePathString, 
						  ("/General/SomePath", DefaultSomePath));
		M_AddConfigEntry (m_IsSomeValueEnabled, 
						  ("/Setup/IsSomeValueEnabled", TRUE));
		M_AddConfigEntry (m_IsSomeOtherValueEnabled, 
						  ("/Setup/IsSomeOtherValueEnabled", FALSE));
		M_AddConfigEntry (m_Integer1,
						  ("/Mape/Integer1", 1, 9, 3));

		// the sub-structure:
		M_AddConfigEntry (m_Struct1.m_Integer1,
						  ("/Mape/Integer1", 10, 99, 30));
		M_AddConfigEntry (m_Struct1.m_Integer2,
						  ("/Mape/Integer2", 20, 77, 40));
		M_AddConfigEntry (m_Struct1.m_IsSomeValueEnabled, 
						  ("/ADifferentKey/SomeKey", FALSE));

		m_IsInitialized = TRUE;
	  }
}

// being gentlemen :)
#undef M_AddConfigEntry


//=========================================================================
// wxConfigEntryManagerTestExtDialog

BEGIN_EVENT_TABLE (wxConfigEntryManagerTestExtDialog, wxExtDialog)
  //  EVT_MENU   (wxID_HELP, wxConfigEntryManagerTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * ConfigEntryManagerDescriptionHtmlString;

wxConfigEntryManagerTestExtDialog::wxConfigEntryManagerTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxConfigEntryManager test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------

	// set up config entry objects
	WxExtLibTestConfigEntryManager.init ();

	// obtain values (usually from wxConfig)
	// easy and typesafe:
	setValuesToDialog ();

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, TRUE));
	wxString DescriptionString;
	DescriptionString += "used config path: \"" 
	  + convertAsciiToHtml(ConfigFilenameString) + "\"<br><br>";
	DescriptionString += ConfigEntryManagerDescriptionHtmlString;
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  PanelSizer,
					  DescriptionString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getHtmlWindow() -> SetBorders (5);
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 2, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	wxSize StringTextCtrlSize (getAdjustedTextCtrlWidth (150),
							   getAdjustedTextCtrlHeight (1, TRUE));
	addTextCtrlWithLabel  (& m_SomePathStringTextCtrl, _("some &path string"),
						   wxStringValidator (& m_SomePathString,
											  m_StatusMessageTarget, _("some path string")),
						   0,
						   StringTextCtrlSize,
						   FlexGridSizer);
	addCheckBoxWithLabel  (& m_IsSomeValueEnabledCheckBox, _("is some value enabled"),
						   wxGenericValidator (& m_IsSomeValueEnabled),
						   0,
						   FlexGridSizer);
	addCheckBoxWithLabel  (& m_IsSomeOtherValueEnabledCheckBox, _("is some other value enabled"),
						   wxGenericValidator (& m_IsSomeOtherValueEnabled),
						   0,
						   FlexGridSizer);
	addTextCtrlWithLabel  (& m_Integer1TextCtrl, _("Integer &1"),
						   wxNumberValidator (& m_Integer1, 
											  1, 9, 
											  m_StatusMessageTarget, _("integer 1")),
						   0,
						   wxDefaultSize,
						   FlexGridSizer);
	addTextCtrlWithLabel  (& m_Struct1_Integer1TextCtrl, _("Struct1-Integer &1"),
						   wxNumberValidator (& m_Struct1_Integer1, 
											  10, 99, 
											  m_StatusMessageTarget, _("struct1-integer 1")),
						   0,
						   wxDefaultSize,
						   FlexGridSizer);
	addTextCtrlWithLabel  (& m_Struct1_Integer1TextCtrl, _("Struct1-Integer &2"),
						   wxNumberValidator (& m_Struct1_Integer2, 
											  20, 77, 
											  m_StatusMessageTarget, _("struct2-integer 1")),
						   0,
						   wxDefaultSize,
						   FlexGridSizer);
	addCheckBoxWithLabel  (& m_Struct1_IsSomeValueEnabledCheckBox, _("struct1-is some value enabled"),
						   wxGenericValidator (& m_Struct1_IsSomeValueEnabled),
						   0,
						   FlexGridSizer);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));

	wxButton * Button;
    addButton (& Button, -1, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnRead), 
			   _("&Read"), FlexGridSizer);
    addButton (& Button, -1, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnWriteModified), 
			   _("&Write mod."), FlexGridSizer);
    Button->SetDefault();
    addButton (& Button, -1, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnSetToDefaults), 
			   _("&Set defaults"), FlexGridSizer);
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxConfigEntryManagerTestExtDialog::OnCancel), 
			   _("Close"), FlexGridSizer);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (TRUE);
}

//-------------------------------------------------------------------------

void wxConfigEntryManagerTestExtDialog::setValuesToDialog()
{
	WxExtLibTestConfigEntryManager.m_SomePathString.get (m_SomePathString);
	WxExtLibTestConfigEntryManager.m_IsSomeValueEnabled.get (m_IsSomeValueEnabled);
	WxExtLibTestConfigEntryManager.m_IsSomeOtherValueEnabled.get (m_IsSomeOtherValueEnabled);
	WxExtLibTestConfigEntryManager.m_Integer1.get (m_Integer1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer1.get (m_Struct1_Integer1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer2.get (m_Struct1_Integer2);
	WxExtLibTestConfigEntryManager.m_Struct1.m_IsSomeValueEnabled.get (m_Struct1_IsSomeValueEnabled);
}

void wxConfigEntryManagerTestExtDialog::setValuesToConfig()
{
	WxExtLibTestConfigEntryManager.m_SomePathString.set (m_SomePathString);
	WxExtLibTestConfigEntryManager.m_IsSomeValueEnabled.set (m_IsSomeValueEnabled);
	WxExtLibTestConfigEntryManager.m_IsSomeOtherValueEnabled.set (m_IsSomeOtherValueEnabled);
	WxExtLibTestConfigEntryManager.m_Integer1.set (m_Integer1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer1.set (m_Struct1_Integer1);
	WxExtLibTestConfigEntryManager.m_Struct1.m_Integer2.set (m_Struct1_Integer2);
	WxExtLibTestConfigEntryManager.m_Struct1.m_IsSomeValueEnabled.set (m_Struct1_IsSomeValueEnabled);
}

//-------------------------------------------------------------------------

void wxConfigEntryManagerTestExtDialog::OnRead(wxCommandEvent & WXUNUSED(Event))
{
    WxExtLibTestConfigEntryManager.readAllConfigEntries ();
	setValuesToDialog ();
	TransferDataToWindow ();
}

void wxConfigEntryManagerTestExtDialog::OnWriteModified(wxCommandEvent & WXUNUSED(Event))
{
    if (ValidateWithMessageBox (-1))
	  {
		setValuesToConfig ();
		WxExtLibTestConfigEntryManager.writeAllConfigEntries ();
	  }
}

void wxConfigEntryManagerTestExtDialog::OnSetToDefaults(wxCommandEvent & WXUNUSED(Event))
{
    WxExtLibTestConfigEntryManager.setDefaultValues ();
	setValuesToDialog ();
	TransferDataToWindow ();
}

void wxConfigEntryManagerTestExtDialog::OnCancel(wxCommandEvent & Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================
// wxTextCtrlSliderPairTestExtDialog

BEGIN_EVENT_TABLE (wxTextCtrlSliderPairTestExtDialog, wxExtDialog)
  //  EVT_MENU   (wxID_HELP, wxTextCtrlSliderPairTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

extern const char * TextCtrlSliderPairValidatorsDescriptionHtmlString;

long TextCtrlSliderPairTestExtDialog_RedModificationLong = 30;
long TextCtrlSliderPairTestExtDialog_GreenModificationLong = 0;
long TextCtrlSliderPairTestExtDialog_BlueModificationLong = -10;

//-------------------------------------------------------------------------

wxTextCtrlSliderPairTestExtDialog::wxTextCtrlSliderPairTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxTextCtrlSliderPair test dialog"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	m_RedModificationLong = TextCtrlSliderPairTestExtDialog_RedModificationLong;
	m_GreenModificationLong = TextCtrlSliderPairTestExtDialog_GreenModificationLong;
	m_BlueModificationLong = TextCtrlSliderPairTestExtDialog_BlueModificationLong;

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, TRUE));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  PanelSizer,
					  TextCtrlSliderPairValidatorsDescriptionHtmlString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getHtmlWindow() -> SetBorders (5);
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

	//-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 3, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

    addTextCtrlSliderPairWithLabel (& m_RedModificationTextCtrl, 
									& m_RedModificationSliderCtrl, _("&Red"),
									& m_RedModificationLong, -100, +100, 
									m_StatusMessageTarget, FlexGridSizer,
									_("red"));
    addTextCtrlSliderPairWithLabel (& m_GreenModificationTextCtrl, 
									& m_GreenModificationSliderCtrl, _("&Green"),
								    & m_GreenModificationLong, -100, +100, 
									m_StatusMessageTarget, FlexGridSizer,
									_("green"));
    addTextCtrlSliderPairWithLabel (& m_BlueModificationTextCtrl, 
									& m_BlueModificationSliderCtrl, _("&Blue"),
									& m_BlueModificationLong, -100, +100, 
									m_StatusMessageTarget, FlexGridSizer,
									_("blue"));

	addWatchedControl (m_RedModificationTextCtrl);
	addWatchedControl (m_GreenModificationTextCtrl);
	addWatchedControl (m_BlueModificationTextCtrl);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxTextCtrlSliderPairTestExtDialog::OnOK), 
			   _("&OK"), FlexGridSizer);
    Button->SetDefault();
    addButton (NULL, wxID_CANCEL, (wxCommandEventFunction) (& wxTextCtrlSliderPairTestExtDialog::OnCancel), 
			   _("Cancel"), FlexGridSizer);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (TRUE);
}

void wxTextCtrlSliderPairTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
	if (ValidateWithMessageBox (wxID_OK))
	  {
	    TextCtrlSliderPairTestExtDialog_RedModificationLong = m_RedModificationLong;
	    TextCtrlSliderPairTestExtDialog_GreenModificationLong = m_GreenModificationLong;
	    TextCtrlSliderPairTestExtDialog_BlueModificationLong = m_BlueModificationLong;
	  }
}

void wxTextCtrlSliderPairTestExtDialog::OnCancel(wxCommandEvent& Event)
{
	wxExtDialog::OnCancel (Event);
}

//=========================================================================
// wxDialogZoomTestExtDialog

BEGIN_EVENT_TABLE (wxDialogZoomTestExtDialog, wxExtDialog)
  //  EVT_MENU   (wxID_HELP, wxDialogZoomTestExtDialog::OnHelp)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxDialogZoomTestExtDialog::wxDialogZoomTestExtDialog (wxWindow * ParentWindow)
  : wxExtDialog (ParentWindow, 
			   -1, 
			   _("wxExtDialog dialog zoom test"),
			   wxDefaultPosition, 
			   wxDefaultSize)
{
	m_DialogZoom = wxExtDialog::getGlobalDialogZoom ();

	setBorderCompression (BorderCompressionValue);

	//-------------------------------------------------------------------------
	m_StatusMessageTarget = new wxStatusMessageTarget (createErrorMessageCtrl (& m_ErrorMessageMultiLineText), "");
	m_StatusMessageTarget -> enableShowMessageBox (FALSE);

    //-------------------------------------------------------------------------

    wxBoxSizer *PanelSizer = new wxBoxSizer (wxVERTICAL);
 
	wxFlexGridSizer * FlexGridSizer = NULL;

	//-------------------------------------------------------------------------
	wxSize DescriptionCtrlSize (getAdjustedTextCtrlWidth (400),
									getAdjustedTextCtrlHeight (1, TRUE));
	wxString DescriptionString = 
	  (_T("<b>dialog zoom support:</b><br><br>\n\n"
		  "Specify a zooming factor of 2 if your display's resolution "
		  "is 2560 x 1920 pixel ;-) "));
	addMultiLineText (& m_DescriptionMultiLineText,
					  0,
					  DescriptionCtrlSize,
					  wxMultiLineText::wxHTML_MODE,
					  PanelSizer,
					  DescriptionString,
					  4, 8, _B(10));
	m_DescriptionMultiLineText.getHtmlWindow() -> SetBorders (5);
	m_DescriptionMultiLineText.getWindow() -> SetBackgroundColour (wxColour (224, 224, 192));

    //-------------------------------------------------------------------------
	addFlexGridSizer (& FlexGridSizer, 2, _B(5), _B(5),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, _B(14));

	addTextCtrlWithLabel  (& m_DialogZoomTextCtrl, _("Dialog &zoom"),
						   wxNumberValidator (& m_DialogZoom, 
											  0.25, 2.0, 
											  m_StatusMessageTarget, _("dialog zoom"),
											  0, "%.2f"),
						   0,
						   wxDefaultSize,
						   FlexGridSizer);
	addTextCtrlWithLabel  (& m_BorderCompressionTextCtrl, _("Border &compression"),
						   wxNumberValidator (& BorderCompressionValue, 
											  0.25, 1., 
											  m_StatusMessageTarget, _("border compression"),
											  0, "%.2f"),
						   0,
						   wxDefaultSize,
						   FlexGridSizer);

    //-------------------------------------------------------------------------
    addFlexGridSizer (& FlexGridSizer, 4, _B(0), _B(10),
					  PanelSizer, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(14));

	wxButton * Button;
    addButton (& Button, wxID_OK, (wxCommandEventFunction) (& wxDialogZoomTestExtDialog::OnOK), 
			   _("&Set"), FlexGridSizer);
    Button->SetDefault();
    addButton (& Button, wxID_CANCEL, NULL, //(wxCommandEventFunction) (& wxDialogZoomTestExtDialog::OnCancel), 
			   _("Close"), FlexGridSizer);

    //-------------------------------------------------------------------------
    PanelSizer->Add (m_ErrorMessageMultiLineText.getWindow(),
        0, wxLEFT|wxRIGHT|wxTOP|wxBOTTOM|wxEXPAND, _B(5));

    SetSizerAndFit (PanelSizer);

	initializeDialog ();
	enableWatchedControlChangeNotification (TRUE);
}

//-------------------------------------------------------------------------

void wxDialogZoomTestExtDialog::OnOK(wxCommandEvent & WXUNUSED(Event))
{
	if (ValidateWithMessageBox (wxID_OK))
	  {
		wxExtDialog::setGlobalDialogZoom (m_DialogZoom);
	  }
}

//=========================================================================
// WxExtLibTestApp

IMPLEMENT_APP(WxExtLibTestApp)

bool WxExtLibTestApp::OnInit()
{
    wxMessageExtDialog::setGlobalTitlePostfix ("WxExtLibTest");

	m_Locale = NULL;
	((WxExtLibTestApp *) wxTheApp) -> updateLanguageSettings ();

    WxExtLibTestFrame *frame = new WxExtLibTestFrame(_T("WxExtLibTest Application"),
                                 wxPoint(50, 50), wxSize(450, 340));

    frame->Show(TRUE);

    return TRUE;
}

void WxExtLibTestApp::updateLanguageSettings ()
{
    delete m_Locale;
	m_Locale = NULL;

	m_Locale = new wxLocale;

	int LanguageIndex = 3;
	switch (LanguageIndex)
	  {
	  case 1:
		m_Locale -> Init (wxLANGUAGE_FRENCH);
		break;
	  case 2:
		m_Locale -> Init (wxLANGUAGE_GERMAN);
		break;
	  case 3:
		m_Locale -> Init (wxLANGUAGE_DEFAULT);
		break;
	  case 0:
	  default:
		m_Locale -> Init (wxLANGUAGE_ENGLISH_UK);
	  }

    // initialize catalogs
    // m_Locale -> AddCatalog (wxT("WxExtLibTest"));
}

//=========================================================================
// WxExtLibTestFrame

BEGIN_EVENT_TABLE(WxExtLibTestFrame, wxFrame)
    EVT_MENU(ID_MessageExtDialogTest, WxExtLibTestFrame::OnMessageExtDialogTest)
    EVT_MENU(ID_NumberValidatorTestDialog, WxExtLibTestFrame::OnNumberValidatorTestDialog)
    EVT_MENU(ID_FormatMessageTestDialog, WxExtLibTestFrame::OnMessageFormatterTest)
    EVT_MENU(ID_ConfigEntryManagerTestDialog, WxExtLibTestFrame::OnConfigEntryManagerTestDialog)
    EVT_MENU(ID_TextCtrlSliderPairTestDialog, WxExtLibTestFrame::OnTextCtrlSliderPairTestDialog)
    EVT_MENU(ID_DialogZoomTestDialog, WxExtLibTestFrame::OnDialogZoomTestDialog)
    EVT_MENU(ID_Quit,  WxExtLibTestFrame::OnQuit)
    EVT_MENU(ID_About, WxExtLibTestFrame::OnAbout)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

WxExtLibTestFrame::WxExtLibTestFrame(const wxString& title, const wxPoint& pos, const wxSize& size, long style)
       : wxFrame(NULL, -1, title, pos, size, style)
{
    // set the frame icon
    SetIcon(wxICON(WxExtLibTest));

    // create the menu bar
    wxMenu *FileMenu = new wxMenu;
    FileMenu->Append(ID_MessageExtDialogTest, _T("&wxMessageExtDialog test..."));
    FileMenu->Append(ID_NumberValidatorTestDialog, _T("S&tatusValidators test dialog..."));
    FileMenu->Append(ID_FormatMessageTestDialog, _T("wx&FormatMessage test dialog..."));
    FileMenu->Append(ID_ConfigEntryManagerTestDialog, _T("wx&ConfigEntryManager test dialog..."));
    FileMenu->Append(ID_TextCtrlSliderPairTestDialog, _T("wxTextCtrl/wx&Slider pair test dialog..."));
    FileMenu->Append(ID_DialogZoomTestDialog, _T("Dialog &zoom test..."));
	FileMenu->AppendSeparator ();
    FileMenu->Append(ID_Quit, _T("E&xit\tAlt-X"), _T("Quit this program"));

    wxMenu *HelpMenu = new wxMenu;
    HelpMenu->Append(ID_About, _T("&About...\tF1"), _T("Show about dialog"));

    wxMenuBar *MenuBar = new wxMenuBar();
    MenuBar->Append(FileMenu, _T("&File"));
    MenuBar->Append(HelpMenu, _T("&Help"));

    SetMenuBar(MenuBar);

    CreateStatusBar(2);

	// wxExtDialog::setGlobalDesktopReferenceSize (wxSize (900, 700));

    WxExtLibTest_DateTime.SetToCurrent();
}

//-------------------------------------------------------------------------

extern const char * MessageExtDialogDescription;

void WxExtLibTestFrame::OnMessageExtDialogTest(wxCommandEvent& WXUNUSED(Event))
{
    // WARN don't know if _T must be around each of the string parts 
    wxMessageExtDialog SomeMessageExtDialog (NULL, 
											 MessageExtDialogDescription,
										  _T("extended message box test"));
	SomeMessageExtDialog.setStyle (wxMessageExtDialog::QuestionStyle);
	const int NoNoButtonIdent = SomeMessageExtDialog.addButton ("&No no");
	/* const int JumpButtonIdent = */ SomeMessageExtDialog.addButton ("&Jump");
	SomeMessageExtDialog.makeLastAddedButtonDefault ();
	SomeMessageExtDialog.addButton ("&Cancel", wxID_CANCEL);
	int ReturnedButtonIdent = SomeMessageExtDialog.ShowModal ();
 	if (ReturnedButtonIdent == NoNoButtonIdent)
 	  {
 		// easiest case: a message box with only an 'OK' button can
 		// be created and displayed with a single function call:
		MessageExtDialog (_T("An <b>error</b> message is hanging around!"),
 						 wxMessageExtDialog::ErrorStyle | wxMessageExtDialog::IsHtmlMode);

		wxMessageExtDialog OtherMessageExtDialog (NULL, 
											  _T("Please decide"),
											  _T(""));
		OtherMessageExtDialog.setStyle (wxMessageExtDialog::CriticalErrorStyle);
		const int FirstButtonIdent = OtherMessageExtDialog.addButton ("&Fast");
		const int SecondButtonIdent = OtherMessageExtDialog.addButton ("&Small");
		const int ThirdButtonIdent = OtherMessageExtDialog.addButton ("&Fast'n'small");
		OtherMessageExtDialog.makeLastAddedButtonDefault ();
		int OtherReturnedButtonIdent = OtherMessageExtDialog.ShowModal ();
 	  }

}

void WxExtLibTestFrame::OnNumberValidatorTestDialog(wxCommandEvent& WXUNUSED(Event))
{
    wxStatusValidatorsTestExtDialog StatusValidatorsTestExtDialog (this);
	StatusValidatorsTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnMessageFormatterTest (wxCommandEvent& WXUNUSED(Event))
{
    wxFormatMessageTestExtDialog FormatMessageTestExtDialog (this);
	FormatMessageTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnConfigEntryManagerTestDialog (wxCommandEvent& WXUNUSED(Event))
{
    wxConfigEntryManagerTestExtDialog ConfigEntryManagerTestExtDialog (this);
	ConfigEntryManagerTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnTextCtrlSliderPairTestDialog(wxCommandEvent& WXUNUSED(Event))
{
    wxTextCtrlSliderPairTestExtDialog TextCtrlSliderPairTestExtDialog (this);
	TextCtrlSliderPairTestExtDialog.ShowModal ();
}

void WxExtLibTestFrame::OnDialogZoomTestDialog (wxCommandEvent& WXUNUSED(Event))
{
    int ResultCode = wxID_CANCEL;
    do 
	  {
		wxDialogZoomTestExtDialog DialogZoomTestExtDialog (this);
		ResultCode = DialogZoomTestExtDialog.ShowModal ();
	  }
	while (ResultCode == wxID_OK);
}

void WxExtLibTestFrame::OnQuit(wxCommandEvent& WXUNUSED(Event))
{
    Close (TRUE);
}

void WxExtLibTestFrame::OnAbout(wxCommandEvent& WXUNUSED(Event))
{
    MessageExtDialog (_T("<font size=\"+2\"><b>WxExtLibTest</b></font><br><br>\n\n"
"<i>Sample program to demonstrate some features of the WxWidgetsExtensions library and how to use them.</i><br><br>\n\n"
"Written by Daniel Kps, 2004."
), 
					 wxMessageExtDialog::InformationStyle | wxMessageExtDialog::IsHtmlMode);


}

//=========================================================================
