
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxWidgetsExtensions library 0.7.1
-----------------------------

COPYRIGHT NOTICE:

WxWidgetsExtensions library Copyright (c) 2003, 2004 Daniel Kps.

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice

-------------------------------------------------------------------------
*/

#ifndef _INCLUDED_WxExtDialog_h  
#define _INCLUDED_WxExtDialog_h  

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!defined(M_NoPragmaInterface))
#   pragma interface "WxExtDialog.h"
#endif

#ifndef WX_PRECOMP
#   include <wx/dialog.h>
#   include <wx/intl.h>
#   include <wx/checkbox.h>
#   include <wx/choice.h>
#   include <wx/radiobut.h>
#   include <wx/statbmp.h>
#   include <wx/sizer.h>
#   include <wx/button.h>
#   include <wx/stattext.h>
#   include <wx/statbox.h>
#   include <wx/slider.h>
#   include <wx/listbox.h>
#   include <wx/valgen.h>
#endif

#include "StatusValidators.h"
#include "WxMisc.h"

//-------------------------------------------------------------------------

#ifdef M_IsMFCCompatibility
//-------------------------------------------------------------------------
// create a wxWindow as child of the specified MFC ParentWindow - this
// is useful for using wxWindows based dialogs together with a MFC
// based parent/frame window
wxWindow * MSWCreateChildWindowForMFCFrame (CWnd * ParentWindow);

#endif // M_IsMFCCompatibility

//-------------------------------------------------------------------------

WX_DEFINE_ARRAY_PTR(wxObject *, CWxObjectArray);

//-------------------------------------------------------------------------
// wxExtDialog: helper class with following purposes:
// - ease creating and adding controls
// - slightly specialized dialog to work with a MFC main window 
// - support for dialog zoom
// - simplification of control-change notification
class wxExtDialog : public wxDialog
{
public:
    wxExtDialog ();

    wxExtDialog(wxWindow *parent, wxWindowID id,
              const wxString& title,
              const wxPoint& pos = wxDefaultPosition,
              const wxSize& size = wxDefaultSize,
              long style_DIALOG_STYLE = wxDEFAULT_DIALOG_STYLE,
              const wxString& name = wxDialogNameStr);

    void initCWxDialog ();

    ~wxExtDialog ();

    virtual void InitDialog ();

#ifdef M_IsNonWxMainIntegration
    //-------------------------------------------------------------------------
    // find the window to use as parent for this dialog if none has been
    // specified explicitly by the user (requires patched version of
    // src/msw/dialog.h with this function made virtual)
    //
    // may return NULL
    virtual wxWindow *FindSuitableParent() const;
#endif

    // show modal dialog and enter modal loop
    // virtual void DoShowModal();

#ifdef M_IsNonWxMainIntegration
#if defined(__WXMSW__)
    // added for MFC main window compatibility:
    // MSWEnableOtherWindows (called by DoShowModal()). Can 
    // be overwritten for the case that the frame window 
    // was not created with wxWindows (requires a patched
    // version of src/msw/dialog.cpp)
    virtual void MSWEnableOtherWindows (bool IsEnable);
#endif
#endif
#if defined(__WXMSW__)
    HWND MSWGetHandle();
#endif

    //-------------------------------------------------------------------------
    // specialized ShowModal() function which
    // centers the dialog before displaying it
    virtual int ShowModal ();

    //-------------------------------------------------------------------------
    // helper functions to make creation of certain often-used dialog control
    // combinations easier (e.g. a wxStaticText and wxTextCtrl may be created
    // with a single call using addTextCtrlWithLabel())
    // - for notes on size specifications with regard to zooming, see
    //   the getAdjusted*Width/Height functions

    wxSizer * addSpace (int Width, int Height, wxSizer * Sizer);

    // DEF ButtonPtrPtr can be NULL
    // DEF ButtonId can be -1 to obtain an automatically generated button id
    wxButton * addButton (wxButton ** ButtonPtrPtr, wxWindowID id,
                          wxCommandEventFunction CommandEventFunction, 
                          const wxString& label, 
                          wxSizer * Sizer,
                          const wxPoint& pos = wxDefaultPosition,
                          const wxSize& size = wxDefaultSize,
                          long style = 0, const wxValidator& validator = wxDefaultValidator);

    wxSizer * addCheckBoxWithLabel (wxCheckBox ** CheckBox,
                                   const wxString & LabelString,
                                   const wxValidator & Validator = wxDefaultValidator,
                                   int Flags = 0,  // Flags can be 0 or wxTE_READONLY
                                   wxSizer * Sizer = NULL,
                                   bool IsLabelOnTheLeft = FALSE);

    wxSizer * addRadioButtonWithLabel (wxRadioButton ** RadioButton,
                                    const wxString & LabelString,
                                    const wxValidator & Validator = wxDefaultValidator,
                                    int RadioCtrlStyle = 0, 
                                    wxSizer * Sizer = NULL);

    wxStaticText * addLabel (wxStaticText ** StaticTextCtrl,
                             const wxString & LabelString,
                             wxSizer * Sizer = NULL,
                             int WindowStyle = wxALIGN_LEFT,
                             const wxSize & Size = wxDefaultSize);

    wxWindow * addMultiLineText (wxMultiLineText * MultiLineText,
                                 int CtrlStyle = 0,
                                 const wxSize & CtrlSize = wxDefaultSize,
                                 int MultiLineTextStyle = 0,
                                 wxSizer * Sizer = NULL);
    wxWindow * addMultiLineText (wxMultiLineText * MultiLineText,
                                 int CtrlStyle,
                                 const wxSize & CtrlSize,
                                 int MultiLineTextStyle,
                                 wxSizer * Sizer,
                                 const wxString & TextString,
                                 int MinLineCount, int MaxLineCount,
								 int BorderWidth=0);

    wxTextCtrl * addTextCtrl (wxTextCtrl ** TextCtrl,
                              const wxValidator & Validator = wxDefaultValidator,
                              int TextCtrlStyle = wxTE_LEFT,
                              const wxSize & Size = wxDefaultSize,
                              wxSizer * Sizer = NULL);

    // TODO add sizer flags for textctrl, e.g. Expandable TextCtrl, ExtraSizer,
    wxSizer * addTextCtrlWithLabel (wxTextCtrl ** TextCtrl,
                                       const wxString & LabelString,
                                       const wxValidator & Validator = wxDefaultValidator,
                                       int TextCtrlStyle = wxTE_LEFT, 
                                       const wxSize & Size = wxDefaultSize,
                                       wxSizer * Sizer = NULL);

    wxSizer * addTextCtrlWithTwoLabels (wxTextCtrl ** TextCtrl,
                                        const wxString & FirstLabelString,
                                        const wxString & SecondLabelString,
                                        const wxValidator & Validator = wxDefaultValidator,
                                        int TextCtrlStyle = wxTE_LEFT, 
                                        const wxSize & Size = wxDefaultSize,
                                        wxSizer * Sizer = NULL);

    // addTextCtrlSliderPairWithLabel():
    // - currently, only a horizontal wxSlider control can be created
    // TODO:
    // - add parameters for wxTextCtrl, wxSlider styles, add size parameters
    wxSizer * addTextCtrlSliderPairWithLabel (wxTextCtrl ** TextCtrl,
                                              wxSlider ** SliderCtrl,
                                              const wxString & LabelString,
                                              long * LongValue, long MinLong, long MaxLong,
                                              wxStatusMessageTarget * StatusMessageTarget,
                                              wxSizer * Sizer, 
                                              const wxString & FieldNameString);

    wxListBox * addListBox (wxListBox ** ListBox, 
                            const wxValidator & Validator,
                            int ChoiceCount, const wxString ChoiceStringArray [],
                            const wxSize& Size = wxDefaultSize);

    wxChoice * addChoiceCtrl (wxChoice ** ChoiceCtrl, 
                              const wxValidator & Validator,
                              int ChoiceCount, const wxString ChoiceStringArray [],
                              const wxSize& Size = wxDefaultSize);

    wxSizer * addChoiceCtrlWithLabel (wxChoice ** ChoiceCtrl,
                                      const wxString & LabelString,
                                      const wxValidator & Validator,
                                      int ChoiceCount, const wxString ChoiceStringArray [],
                                      const wxSize & Size = wxDefaultSize,
                                      wxSizer * Sizer = NULL);

    wxSizer * addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                               const unsigned char * ImageData,
                               size_t ImageDataSize,
                               const wxPoint& Position = wxDefaultPosition,
                               const wxSize& Size = wxDefaultSize,
                               wxSizer * Sizer = NULL);
    wxSizer * addStaticBitmap (wxStaticBitmap ** StaticBitmapPtr,
                               const char * ResourceNameString,
                               const wxPoint& Position,
                               const wxSize& Size,
                               wxSizer * Sizer);

    //-------------------------------------------------------------------------
    // creation of status message TextCtrl with required flags (e.g. wxTE_READONLY)

    wxMultiLineText * createErrorMessageCtrl (wxMultiLineText * ErrorMessageMultiLineText);

    //-------------------------------------------------------------------------
    // TODO could write some Sizer for automatic horizontal or vertical layout

    void addFlexGridSizer (wxFlexGridSizer ** FlexGridSizer,
                           int Columns, int VGap, int HGap);
    void addFlexGridSizer (wxFlexGridSizer ** FlexGridSizer,
                           int Columns, int VGap, int HGap,
                           wxSizer * OuterSizer, int AddFlags, int AddBorder);
    void addStaticBox (wxFlexGridSizer ** FlexGridSizer,
                       const wxString & LabelString,
                       int Columns, int VGap, int HGap,
                       wxSizer * OuterSizer, int AddFlags, int AddBorder);

    //-------------------------------------------------------------------------

    // createDialogFont()
    // - it contains some 'handicrafted' logic to select a well-reable
    //   (not to small) font depending on the used platform (must specify
    //   wxDEFAULT as family for this)
    wxFont createDialogFont (int PointSize, 
                             int Family, 
                             int Style, 
                             int Weight, 
                             const bool IsUnderlined = FALSE, 
                             const wxString& FaceName = "", 
                             wxFontEncoding Encoding = wxFONTENCODING_DEFAULT,
                             int * RequestedPointSize = NULL,
                             bool IsCreateFont = TRUE);

    //-------------------------------------------------------------------------
    // functions for calculating pixel widths/heights based on some desired
    // zoom value
    // Notes:
    // - The getAdjusted...Size() functions in part use 'handicrafted' formulas (e.g.
    //   getAdjustedTextCtrlHeight(), getAdjustedButtonHeight()), specific
    //   to each of the different platforms/window systems (currently, 
    //   available for wxMSW, wxX11, wxGTK, wxMotif). 
    // - Currently, these functions assume a font size equal to the font
    //   size set for the dialog (e.g. set via setDialogZoom()).
    // - Currently, the function which creates controls must call the
    //   getAdjusted*Width/Height functions itself. For cases where this
    //   flexibility is not needed, a mode should be added so that 
    //   addTextCtrl()/addSlider etc. functions call the corresponding
    //   getAdjusted*Width/Height() functions implicitely.
    virtual int getAdjustedBorderSize (int BorderSize);
    virtual int getAdjustedTextCtrlWidth (int TextCtrlWidth);
    virtual int getAdjustedTextCtrlHeight (int TextCtrlHeight, bool IsFromLineCount = FALSE);
    virtual int getAdjustedButtonWidth (int ButtonWidth);
    virtual int getAdjustedButtonHeight ();
    virtual int getAdjustedSliderWidth (int SliderWidth);
    virtual int getAdjustedSliderHeight (int SliderHeight);
    virtual int getAdjustedBitmapWidth (int BitmapWidth);
    virtual int getAdjustedBitmapHeight (int BitmapHeight);

    virtual void adjustMultiLineTextSize (wxMultiLineText & MultiLineText,
                                          int MinLineCount, int MaxLineCount);

    int getDialogFontSize ();
    int getDialogFontHeight ();

    virtual int getAdjustedProportionalWidth(int Width);
    virtual int getAdjustedProportionalHeight(int Height);
    virtual int getAdjustedFontLikeWidth(int Width);
    virtual int getAdjustedFontLikeHeight(int Height);

    // aliases for less typing overhead:
    int _B(int BorderSize) { return getAdjustedBorderSize (BorderSize); } 

    void setDefaultButtonSize (int Width, int Height);

    void setHtmlWindowFonts (wxHtmlWindow * HtmlWindow,
                             int BaseSize,
                             bool IsUseReadableFontSizes = TRUE,
                             bool IsUseScaleableFont = TRUE);
    void excludeRange (int & PointSize, int ExcludeRangeMin, int ExcludeRangeMax = -1);

    //-------------------------------------------------------------------------
    //-- dialog zoom support:

    // setDialogZoom() should be called before getAdjustedBorderSize() etc.
    // is used, because calling setDialogZoom() after having created sizers
    // with absolute pixel widths/heights/border sizes etc., setDialogZoom()
    // has no effect
    // ZoomValue should be something between 0.5 and 1.5
    // a value of 1. means no zooming
    virtual double getZoom ();
    void setDialogZoom (double DialogZoomValue);
    double getDialogZoom ();
    static void setGlobalDialogZoom (double ZoomValue);
    static double getGlobalDialogZoom ();
    void setDesktopReferenceSize (const wxSize & Size);
    static void setGlobalDesktopReferenceSize (const wxSize & Size);

    // BorderCompressionValue should be something between 0.5 and 1.0
    // a value of 1. means no border compression
    // border compression may be useful for non-modal dialogs which 
    // should occupy as least as possible space on the screen (while using
    // a still readable font) - using this function, the same dialog
    // can be used modal (with setting border compression to the default,
    // 1.) and non-modal (with setting border compression to e.g. 0.5)
    void setBorderCompression (double BorderCompressionValue);

    //-------------------------------------------------------------------------
    wxSize getSizeFromDefaults (const wxSize & Size, const wxSize & DefaultSize);
    wxSize getSizeFromAspectRatio (const wxSize & Size, const wxSize & AspectRatioAsSize);

    //-------------------------------------------------------------------------
    // support for control change notification
    // - most normal notifications are dispatched to handleWatchedControlChange()
    //   (call addWatchedControl() for desired controls)
    // - no need for static message handlers, useful if controls use 
    //   dynamically selected Id's

    virtual void enableWatchedControlChangeNotification (bool IsWatchedControlChangeNotification);
    virtual void addWatchedControl (wxWindow * Window);
    virtual void handleControlChange(wxCommandEvent & Event);
    virtual void handleWatchedControlChange(wxCommandEvent & Event);

    //-------------------------------------------------------------------------
    // notification functions called by the static event handler

    void OnTextCtrlChanged(wxCommandEvent& Event);
    // void OnSliderCtrlChanged(wxCommandEvent& Event);
    void OnSliderCtrlChanged(wxScrollEvent & Event);
    void OnRadioButtonSelected(wxCommandEvent& Event);
    void OnRadioBoxSelected(wxCommandEvent& Event);
    void OnCheckBoxSelected(wxCommandEvent& Event);
    void OnComboBoxSelected(wxCommandEvent& Event);
    void OnListBoxSelected(wxCommandEvent& Event);
    void OnChoiceCtrlSelected(wxCommandEvent& Event);

    //-------------------------------------------------------------------------
    // specialized version of wxDialog::TransferDataToWindow() which disables
    // control change notifications while data is transferred to the controls
    // (otherwise, e.g. wxTextCtrl()->SetValue() would trigger a notification)
    virtual bool TransferDataToWindow();

    virtual void initializeDialog ();

    // execute validation with showing a message box for errors 
    // if ReturnCode != -1, EndDialog(ReturnCode) is called if
    // validation was successful
    bool ValidateWithMessageBox (int ReturnCode = -1);

    //-------------------------------------------------------------------------

protected:
    wxMultiLineText m_ErrorMessageMultiLineText;
    wxStatusMessageTarget * m_StatusMessageTarget;

    int m_DialogFontSize;
    int m_DialogFontHeight;

    wxSize m_DefaultButtonSize;
    wxSize m_DefaultTextCtrlSize;
    wxSize m_DefaultListBoxSize;
    wxSize m_DefaultChoiceCtrlSize;
    double m_ZoomValue;
    double m_DialogZoomValue;
    static double m_GlobalDialogZoom;
    wxSize m_DesktopReferenceSize;
    static wxSize m_GlobalDesktopReferenceSize;
    double m_BorderCompressionValue;

    bool m_IsWatchedControlChangeNotification;
    CWxObjectArray m_WatchedObjectArray;
    // m_IsDialogInitialized: flag to let control change notification 
    // appear only after the dialog is initialized:
    bool m_IsDialogInitialized;

    DECLARE_EVENT_TABLE()
};

//-------------------------------------------------------------------------

#endif
