
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxWidgetsExtensions library 0.7.1
-----------------------------

COPYRIGHT NOTICE:

WxWidgetsExtensions library Copyright (c) 2003, 2004 Daniel Kps.

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice

-------------------------------------------------------------------------
*/

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
#   pragma implementation "TextCtrlSliderPairValidators.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include "wx/dialog.h"
#endif

#include "TextCtrlSliderPairValidators.h"

#include "WxExtDialog.h"

//-------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxTextCtrlSliderPairTextCtrlValidator, wxNumberValidator)

BEGIN_EVENT_TABLE(wxTextCtrlSliderPairTextCtrlValidator, wxNumberValidator)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTextCtrlSliderPairTextCtrlValidator::wxTextCtrlSliderPairTextCtrlValidator()
{
    m_AssociatedSliderValidator = NULL;
}

wxTextCtrlSliderPairTextCtrlValidator::wxTextCtrlSliderPairTextCtrlValidator
        (
         long * LongValue, long MinLong, long MaxLong,
         wxStatusMessageTarget * StatusMessageTarget,
         const wxString & FieldNameString
         )
          : wxNumberValidator (LongValue, MinLong, MaxLong, StatusMessageTarget,
                               FieldNameString)
{
    m_AssociatedSliderValidator = NULL;
}

wxTextCtrlSliderPairTextCtrlValidator::wxTextCtrlSliderPairTextCtrlValidator(const wxTextCtrlSliderPairTextCtrlValidator& TextCtrlSliderPairTextCtrlValidator)
    : wxNumberValidator()
{
    Copy(TextCtrlSliderPairTextCtrlValidator);
}

bool wxTextCtrlSliderPairTextCtrlValidator::Copy(const wxTextCtrlSliderPairTextCtrlValidator& TextCtrlSliderPairTextCtrlValidator)
{
    wxNumberValidator::Copy(TextCtrlSliderPairTextCtrlValidator);

    m_AssociatedSliderValidator = TextCtrlSliderPairTextCtrlValidator.m_AssociatedSliderValidator;

    return TRUE;
}

wxTextCtrlSliderPairTextCtrlValidator::~wxTextCtrlSliderPairTextCtrlValidator()
{
    if (m_AssociatedSliderValidator)
      {
        m_AssociatedSliderValidator -> setAssociatedTextCtrlValidator (NULL);
      }
    m_AssociatedSliderValidator = NULL;
}

//-------------------------------------------------------------------------

void wxTextCtrlSliderPairTextCtrlValidator::setAssociatedSliderValidator (
    wxTextCtrlSliderPairSliderValidator * AssociatedSliderValidator)
{
    m_AssociatedSliderValidator = AssociatedSliderValidator;
}

//-------------------------------------------------------------------------

// called to transfer data to the window
bool wxTextCtrlSliderPairTextCtrlValidator::TransferToWindow(void)
{
    wxNumberValidator::TransferToWindow ();

#if (defined(__WXMSW__) || defined(__WXGTK__))
    // under WXMSW and WXGTK, a text control change message is generated
    // when setting the wxTextCtrl which in turn causes informTextCtrlChange()
    // to be called. This doesn't happen under some other ports (WXMOTIF,
    // WXX11):
#elif (defined(__WXMOTIF__) || defined(__WXX11__))
    if (m_LongValue != NULL
        && m_AssociatedSliderValidator != NULL)
      {
        m_AssociatedSliderValidator -> informTextCtrlChange (* m_LongValue);
      }
#else
#   pragma message ("Please adjust function wxTextCtrlSliderPairTextCtrlValidator::TransferToWindow() for your wxWindows port.")
#endif
    return TRUE;
}

void wxTextCtrlSliderPairTextCtrlValidator::handleValidInput (const wxNumberValidatorVariant & Variant)
{
    if (m_AssociatedSliderValidator)
      {
        long TempLong;
        Variant.getLong (& TempLong);
        m_AssociatedSliderValidator -> informTextCtrlChange (TempLong);
      }
}

//-------------------------------------------------------------------------

void wxTextCtrlSliderPairTextCtrlValidator::informSliderChange (long TempLong)
{    
    wxString TextCtrlContentString;
    wxNumberValidatorVariant TempVariant;
    TempVariant.setLong (TempLong);
    transferToWindowHelper (TempVariant, TextCtrlContentString);
    setTextCtrlContent (TextCtrlContentString);
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxTextCtrlSliderPairSliderValidator, wxValidator)

BEGIN_EVENT_TABLE(wxTextCtrlSliderPairSliderValidator, wxValidator)
    EVT_SCROLL (wxTextCtrlSliderPairSliderValidator::OnScrollEvent)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTextCtrlSliderPairSliderValidator::wxTextCtrlSliderPairSliderValidator()
{
    m_AssociatedTextCtrlValidator = NULL;

    m_IsLastSliderPositionValid = FALSE;
    m_LastSliderPositionLong = 0;
}

wxTextCtrlSliderPairSliderValidator::wxTextCtrlSliderPairSliderValidator(const wxTextCtrlSliderPairSliderValidator& TextCtrlSliderPairSliderValidator)
    : wxValidator()
{
    Copy(TextCtrlSliderPairSliderValidator);
}

bool wxTextCtrlSliderPairSliderValidator::Copy(const wxTextCtrlSliderPairSliderValidator& TextCtrlSliderPairSliderValidator)
{
    wxValidator::Copy(TextCtrlSliderPairSliderValidator);

    m_AssociatedTextCtrlValidator = TextCtrlSliderPairSliderValidator.m_AssociatedTextCtrlValidator;
    m_IsLastSliderPositionValid = TextCtrlSliderPairSliderValidator.m_IsLastSliderPositionValid;
    m_LastSliderPositionLong = TextCtrlSliderPairSliderValidator.m_LastSliderPositionLong;

    return TRUE;
}

wxTextCtrlSliderPairSliderValidator::~wxTextCtrlSliderPairSliderValidator()
{
    if (m_AssociatedTextCtrlValidator)
      {
        m_AssociatedTextCtrlValidator -> setAssociatedSliderValidator (NULL);
      }
    m_AssociatedTextCtrlValidator = NULL;
}

//-------------------------------------------------------------------------

void wxTextCtrlSliderPairSliderValidator::setAssociatedTextCtrlValidator (
    wxTextCtrlSliderPairTextCtrlValidator * AssociatedTextCtrlValidator)
{
    m_AssociatedTextCtrlValidator = AssociatedTextCtrlValidator;
}

//-------------------------------------------------------------------------

bool wxTextCtrlSliderPairSliderValidator::Validate(wxWindow * WXUNUSED(Parent))
{
    // validity check of associated wxTextCtrl is assumed to be done
    // by wxTextCtrlSliderPairTextCtrlValidator
    return TRUE;
}

bool wxTextCtrlSliderPairSliderValidator::TransferToWindow(void)
{
    // Currently, setting any value to the wxTextCtrl causes a 
    // wxTextCtrl content change event to be generated. This will,
    // in turn,  call our informTextCtrlChange() function, which
    // will set the slider position. 
    // So to avoid setting the slider position twice, we do nothing
    // here.
    return TRUE;
}

bool wxTextCtrlSliderPairSliderValidator::TransferFromWindow(void)
{
    // transfer of data into the variable is assumed to be done by
    // wxTextCtrlSliderPairTextCtrlValidator, so to avoid setting the
    // variable twice, we do nothing here
    return TRUE;
}

//-------------------------------------------------------------------------

// void wxTextCtrlSliderPairSliderValidator::OnScrollEvent(wxCommandEvent& Event)
void wxTextCtrlSliderPairSliderValidator::OnScrollEvent(wxScrollEvent & Event)
{
    Event.Skip();

    long CurrentSliderPositionLong;
    wxSlider * Slider = (wxSlider *) m_validatorWindow ;
    CurrentSliderPositionLong = Slider -> GetValue ();

    if (m_AssociatedTextCtrlValidator)
      {
        if (CurrentSliderPositionLong != m_LastSliderPositionLong)
          {
            m_AssociatedTextCtrlValidator -> informSliderChange (CurrentSliderPositionLong);
            m_IsLastSliderPositionValid = TRUE;
            m_LastSliderPositionLong = CurrentSliderPositionLong;
          }
      }
}

//-------------------------------------------------------------------------

void wxTextCtrlSliderPairSliderValidator::informTextCtrlChange (long TempLong)
{
    if (m_validatorWindow)
      {
        wxSlider * Slider = (wxSlider *) m_validatorWindow ;
        Slider -> SetValue (TempLong);
      }
}

//-------------------------------------------------------------------------


