
/*
-------------------------------------------------------------------------
This file is part of WxWidgetsExtensions library.
-------------------------------------------------------------------------

WxWidgetsExtensions library 0.7.1
-----------------------------

COPYRIGHT NOTICE:

WxWidgetsExtensions library Copyright (c) 2003, 2004 Daniel Kps.

The WxWidgetsExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of WxWidgetsExtensions library Copyright notice

-------------------------------------------------------------------------
*/

//-------------------------------------------------------------------------

#if defined(__GNUG__) && (!defined(__APPLE__)) && (!(defined M_NoPragmaInterface))
#   pragma implementation "StatusValidators.h"
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
  #pragma hdrstop
#endif

#ifndef WX_PRECOMP
  #include <stdio.h>
  #include "wx/textctrl.h"
  #include "wx/utils.h"
  #include "wx/msgdlg.h"
  #include "wx/intl.h"
#endif

#include "StatusValidators.h"

// #include <ctype.h>
// #include <string.h>
// #include <stdlib.h>

// #ifdef __SALFORDC__
//    #include <clib.h>
// #endif

#include "MessageExtDialog.h"
#include "WxMisc.h"

#include "safecast.h"

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxStatusMessageTarget, wxObject)

//-------------------------------------------------------------------------

wxStatusMessageTarget::wxStatusMessageTarget()
{
    m_ErrorMessageMultiLineText = NULL;
    m_IsShowMessageBoxEnabled = TRUE;
}

wxStatusMessageTarget::wxStatusMessageTarget(wxMultiLineText * ErrorMessageMultiLineText,
                                             const wxString & NonErrorMessageString)
{
    m_ErrorMessageMultiLineText = ErrorMessageMultiLineText;
    m_NonErrorMessageString = NonErrorMessageString;
}

wxStatusMessageTarget::wxStatusMessageTarget(const wxStatusMessageTarget& StatusMessageTarget)
    : wxObject()
{
    Copy(StatusMessageTarget);
}

bool wxStatusMessageTarget::Copy(const wxStatusMessageTarget& StatusMessageTarget)
{
    // wxObject::Copy(StatusMessageTarget);

    m_ErrorMessageMultiLineText = StatusMessageTarget.m_ErrorMessageMultiLineText;
    m_NonErrorMessageString = StatusMessageTarget.m_NonErrorMessageString;

    return TRUE;
}

wxStatusMessageTarget::~wxStatusMessageTarget()
{
}

//-------------------------------------------------------------------------

void wxStatusMessageTarget::setMessage (const wxString & MessageString, bool IsError)
{
    m_MessageString = MessageString;
    m_IsError = IsError;
}

void wxStatusMessageTarget::display (wxWindow * WXUNUSED(ParentWindow))
{
    if (m_ErrorMessageMultiLineText != NULL)
      {
        if (! m_NonErrorMessageString.IsEmpty() && ! m_IsError)
          {
            m_ErrorMessageMultiLineText -> getWindow() -> SetForegroundColour (wxColour (128, 0, 64));
            m_ErrorMessageMultiLineText -> setText (m_NonErrorMessageString);
          }
        else
          {
            m_ErrorMessageMultiLineText -> getWindow() -> SetForegroundColour (wxColour (64, 0, 128));
            m_ErrorMessageMultiLineText -> setText (m_MessageString);
          }
      }

//  if (m_IsError && m_IsShowMessageBoxEnabled)
//    {
//      wxMessageBox(m_MessageString, _("Input error"),
//                   wxOK | wxICON_EXCLAMATION, ParentWindow);
//    }
}

void wxStatusMessageTarget::clear ()
{
    if (m_ErrorMessageMultiLineText != NULL)
      {
        m_ErrorMessageMultiLineText -> getWindow() -> SetForegroundColour (*wxBLACK);
        m_ErrorMessageMultiLineText -> setText ("");
      }
}

void wxStatusMessageTarget::enableShowMessageBox (bool IsShowMessageBoxEnabled)
{
    m_IsShowMessageBoxEnabled = IsShowMessageBoxEnabled;
}

bool wxStatusMessageTarget::isShowMessageBoxEnabled ()
{
    return m_IsShowMessageBoxEnabled;
}

//=========================================================================

IMPLEMENT_CLASS(wxROGenericValidator, wxGenericValidator)

//-------------------------------------------------------------------------

wxROGenericValidator::wxROGenericValidator(bool* val)
  : wxGenericValidator (val)
{
}

wxROGenericValidator::wxROGenericValidator(int* val)
  : wxGenericValidator (val)
{
}

wxROGenericValidator::wxROGenericValidator(wxString* val)
  : wxGenericValidator (val)
{
}

wxROGenericValidator::wxROGenericValidator(wxArrayInt* val)
  : wxGenericValidator (val)
{
}

//=========================================================================

IMPLEMENT_ABSTRACT_CLASS(wxTextCtrlStatusValidator, wxValidator)

BEGIN_EVENT_TABLE(wxTextCtrlStatusValidator, wxValidator)
    EVT_CHAR(wxTextCtrlStatusValidator::OnChar)
    EVT_TEXT(wxID_ANY, wxTextCtrlStatusValidator::OnTextChanged)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxTextCtrlStatusValidator::wxTextCtrlStatusValidator()
{
    m_StatusMessageTarget = NULL;
    m_Flags = 0;
}

wxTextCtrlStatusValidator::wxTextCtrlStatusValidator(wxStatusMessageTarget * StatusMessageTarget,
                                     int Flags)
{
    m_StatusMessageTarget = StatusMessageTarget;
    m_Flags = Flags;
}

wxTextCtrlStatusValidator::wxTextCtrlStatusValidator(const wxTextCtrlStatusValidator& TextCtrlStatusValidator)
    : wxValidator()
{
    Copy(TextCtrlStatusValidator);
}

bool wxTextCtrlStatusValidator::Copy(const wxTextCtrlStatusValidator& TextCtrlStatusValidator)
{
    wxValidator::Copy(TextCtrlStatusValidator);

    m_StatusMessageTarget = TextCtrlStatusValidator.m_StatusMessageTarget;
    m_Flags = TextCtrlStatusValidator.m_Flags;

    return TRUE;
}

wxTextCtrlStatusValidator::~wxTextCtrlStatusValidator()
{
}

//-------------------------------------------------------------------------

bool wxTextCtrlStatusValidator::TransferToWindow(void)
{
    if( !checkValidator() )
        return FALSE;

    wxString TextCtrlContentString;
    transferToWindow(TextCtrlContentString);
    setTextCtrlContent (TextCtrlContentString);

    return TRUE;
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::getTextCtrlContent (wxString & TextCtrlContentString)
{
    wxTextCtrl *TextCtrl = (wxTextCtrl *) m_validatorWindow;
    TextCtrlContentString = TextCtrl -> GetValue ();
}

void wxTextCtrlStatusValidator::setTextCtrlContent (const wxString & TextCtrlContentString)
{
    wxTextCtrl *TextCtrl = (wxTextCtrl *) m_validatorWindow;
    TextCtrl -> SetValue (TextCtrlContentString);
}

//-------------------------------------------------------------------------

bool wxTextCtrlStatusValidator::Validate(wxWindow * ParentWindow)
{
    if (!checkValidator())
        return FALSE;

    // return if the window is disabled
    wxTextCtrl *TextCtrl = (wxTextCtrl *) m_validatorWindow ;
    if (!TextCtrl->IsEnabled())
        return TRUE;

    wxString TextCtrlContentString;
    getTextCtrlContent (TextCtrlContentString);
    wxString ErrorMessageString;
    bool IsOk = transferFromWindowTemporary (TextCtrlContentString,
                                             ErrorMessageString);

    if (IsOk)
      {
        showStatusMessage ("", FALSE, ParentWindow);
      }
    else
      {
        showStatusMessage (ErrorMessageString, TRUE, ParentWindow);

        if (m_StatusMessageTarget != NULL
            && m_StatusMessageTarget -> isShowMessageBoxEnabled())
          {
            // Because of intended handleWatchedControlChange()
            // implementations which would call Validate() for any control
            // change (e.g. any time a character is typed in a wxTextCtrl by
            // the user), we set the focus to the wxTextCtrl with an input error
            // only if the message box is enabled for the StatusMessageTarget.
            m_validatorWindow->SetFocus();

//          wxMessageBox(ErrorMessageString, _("Input error"),
//                       wxOK | wxICON_EXCLAMATION, ParentWindow);

            wxMessageExtDialog MessageExtDialog (ParentWindow, 
                                              ErrorMessageString,
                                              _("Input error"));
            MessageExtDialog.addButton (_("Cancel"), wxID_CANCEL);
            MessageExtDialog.makeLastAddedButtonDefault ();
            MessageExtDialog.ShowModal ();
          }
      }

    return IsOk;
}

bool wxTextCtrlStatusValidator::TransferFromWindow(void)
{
    if (!checkValidator())
        return FALSE;

    // return if window is disabled
    wxTextCtrl *TextCtrl = (wxTextCtrl *) m_validatorWindow ;
    if ( !TextCtrl->IsEnabled() )
        return TRUE;

    // theoretically, the string in the wxTextCtrl should be valid here
    // because Validate() would have been called before successfully
    wxString TextCtrlContentString;
    getTextCtrlContent (TextCtrlContentString);
    wxString ErrorMessageString;
    bool IsOk = transferFromWindowPersistent (TextCtrlContentString,
                                              ErrorMessageString);

    return IsOk;
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::OnChar(wxKeyEvent& Event)
{
    if (m_validatorWindow 
        && (m_Flags & IsFilterInputChars))
      {
        // here, filtering of keyboard events could be realized
      }

    Event.Skip();
}

// Note that OnTextChanged() will always be sent when the text controls contents
// changes (scope: wxMSW, wxGTK) - whether this is due to user input or comes 
// from the program itself (for example, if SetValue() is called).
void wxTextCtrlStatusValidator::OnTextChanged(wxCommandEvent& Event)
{
    if (m_validatorWindow)
      {
        // check if string that is now in the TextCtrl is valid; if
        // not, display the error message in the status control (if available)
        wxString TextCtrlContentString;
        getTextCtrlContent (TextCtrlContentString);
        wxString ErrorMessageString;
        if (transferFromWindowTemporary (TextCtrlContentString,
                                         ErrorMessageString, TRUE))
          {
            showStatusMessage ("", FALSE, NULL);
            // handleValidInput (TempLong);
          }
        else
          {
            showStatusMessage (ErrorMessageString, TRUE, NULL);
          }
      }

    Event.Skip ();
}

//-------------------------------------------------------------------------

void wxTextCtrlStatusValidator::showStatusMessage (const wxString & MessageString, 
                                                   bool IsError,
                                                   wxWindow * ParentWindow)
{
    // use m_StatusMessageTarget for output of error message if available,
    // otherwise don't display error message immediatly (it will be shown in
    // a message box later when Validate() is called by the dialog)

    if (m_StatusMessageTarget != NULL)
      {
        m_StatusMessageTarget -> setMessage (MessageString, IsError);
        m_StatusMessageTarget -> display (ParentWindow);
      }
}

//-------------------------------------------------------------------------

bool wxTextCtrlStatusValidator::checkValidator() const
{
    wxCHECK_MSG (m_validatorWindow, FALSE,
                 _T("No window associated with validator"));
    wxCHECK_MSG (m_validatorWindow->IsKindOf(CLASSINFO(wxTextCtrl)), FALSE,
                 _T("Associated control must be a wxTextCtrl"));
    
    return TRUE;
}

//=========================================================================

wxNumberValidatorVariant::wxNumberValidatorVariant ()
{
    m_Type = UndefinedType;
    m_Long = 0;
    m_Double = 0.;
}

bool wxNumberValidatorVariant::getIsLong () const
{
    return m_Type == LongType;
}

bool wxNumberValidatorVariant::getIsDouble () const
{
    return m_Type == DoubleType;
}

long wxNumberValidatorVariant::getLong () const
{
    return m_Long;
}

double wxNumberValidatorVariant::getDouble () const
{
    return m_Double;
}

void wxNumberValidatorVariant::getLong (long * Long) const
{
    * Long = m_Long;
}

void wxNumberValidatorVariant::getDouble (double * Double) const
{
    * Double = m_Double;
}

void wxNumberValidatorVariant::setLong (long Long)
{
    m_Long = Long;
    m_Double = 0.;
    m_Type = LongType;
}

void wxNumberValidatorVariant::setDouble (const double & Double)
{
    m_Long = 0;
    m_Double = Double;
    m_Type = DoubleType;
}

bool wxNumberValidatorVariant::operator== (const wxNumberValidatorVariant & Variant) const
{
    // this equality test operator requires unused elements to be uniquely set
    // to a certain value (e.g. 0 or 0.) to work as expected.
    bool IsEqual = m_Type == Variant.m_Type
      && m_Long == Variant.m_Long
      && m_Double == Variant.m_Double;
    return IsEqual;
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxNumberValidator, wxTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxNumberValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxNumberValidator::wxNumberValidator()
{
    m_IntegerValue = NULL;
    m_LongValue = NULL;
    m_DoubleValue = NULL;

    m_MinVariant.setLong (0);
    m_MaxVariant.setLong (0);
    m_UndefinedVariant.setLong (0);
    m_FieldNameString = "";
}

wxNumberValidator::wxNumberValidator(int * IntegerValue, int MinInteger, int MaxInteger,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int Flags, int UndefinedInteger)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_IntegerValue = IntegerValue;
    m_LongValue = NULL;
    m_DoubleValue = NULL;

    m_MinVariant.setLong (MinInteger);
    m_MaxVariant.setLong (MaxInteger);
    m_UndefinedVariant.setLong (UndefinedInteger);

    m_FieldNameString = FieldNameString;

    m_FormatString = "%ld";
}

wxNumberValidator::wxNumberValidator(long * LongValue, long MinLong, long MaxLong,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int Flags, long UndefinedLong)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_IntegerValue = NULL;
    m_LongValue = LongValue;
    m_DoubleValue = NULL;

    m_MinVariant.setLong (MinLong);
    m_MaxVariant.setLong (MaxLong);
    m_UndefinedVariant.setLong (UndefinedLong);

    m_FieldNameString = FieldNameString;

    m_FormatString = "%ld";
}

wxNumberValidator::wxNumberValidator(double * DoubleValue, double MinDouble, double MaxDouble,
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int Flags, 
                                     const wxString & FormatString,
                                     double UndefinedDouble)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_IntegerValue = NULL;
    m_LongValue = NULL;
    m_DoubleValue = DoubleValue;

    m_MinVariant.setDouble (MinDouble);
    m_MaxVariant.setDouble (MaxDouble);
    m_UndefinedVariant.setDouble (UndefinedDouble);

    m_FieldNameString = FieldNameString;

    m_FormatString = FormatString;
}

wxNumberValidator::wxNumberValidator(const wxNumberValidator& NumberValidator)
    : wxTextCtrlStatusValidator()
{
    Copy(NumberValidator);
}

bool wxNumberValidator::Copy(const wxNumberValidator& NumberValidator)
{
    wxTextCtrlStatusValidator::Copy(NumberValidator);

    m_IntegerValue = NumberValidator.m_IntegerValue ;
    m_LongValue = NumberValidator.m_LongValue ;
    m_DoubleValue = NumberValidator.m_DoubleValue ;

    m_MinVariant = NumberValidator.m_MinVariant;
    m_MaxVariant = NumberValidator.m_MaxVariant;
    m_UndefinedVariant = NumberValidator.m_UndefinedVariant;

    m_FieldNameString = NumberValidator.m_FieldNameString;

    m_FormatString = NumberValidator.m_FormatString;

    return TRUE;
}

wxNumberValidator::~wxNumberValidator()
{
}

//-------------------------------------------------------------------------

void wxNumberValidator::transferToWindow (wxString & TextCtrlContentString)
{
    wxNumberValidatorVariant TempVariant;
    if (m_IntegerValue != NULL)
      {
        TempVariant.setLong (* m_IntegerValue);
      }
    else if (m_LongValue != NULL)
      {
        TempVariant.setLong (* m_LongValue);
      }
    else if (m_DoubleValue != NULL)
      {
        TempVariant.setDouble (* m_DoubleValue);
      }
    transferToWindowHelper (TempVariant, TextCtrlContentString);
}

void wxNumberValidator::transferToWindowHelper (const wxNumberValidatorVariant & TempVariant, 
                                                wxString & TextCtrlContentString)
{
    if ((m_Flags & IsEmptyAllowed) 
        && (TempVariant == m_UndefinedVariant))
      {
        TextCtrlContentString = "";
      }
    else
      {
        if (TempVariant.getIsLong ())
          {
            long Long;
            TempVariant.getLong (& Long);
            TextCtrlContentString = wxString::Format (m_FormatString, Long);
          }
        else if (TempVariant.getIsDouble())
          {
            double Double;
            TempVariant.getDouble (& Double);
            TextCtrlContentString = wxString::Format (m_FormatString, Double);
          }
      }
}

//-------------------------------------------------------------------------

bool wxNumberValidator::transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                                     wxString & ErrorMessageString,
                                                     bool IsTextCtrlChangeEvent)
{
    wxNumberValidatorVariant TempVariant;
    bool IsOk = transferFromWindowHelper (TextCtrlContentString,
                                          & TempVariant, ErrorMessageString);
    if (IsOk && IsTextCtrlChangeEvent)
      handleValidInput (TempVariant);

    return IsOk;
}

bool wxNumberValidator::transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                                      wxString & ErrorMessageString)
{
    bool IsOk = TRUE;
    wxNumberValidatorVariant TempVariant;
    
    IsOk = transferFromWindowHelper (TextCtrlContentString,
                                     & TempVariant, ErrorMessageString);

    if (m_IntegerValue != NULL)
      {
        long TempLong;
        TempVariant.getLong (& TempLong);
        * m_IntegerValue = TempLong;
      }
    else if (m_LongValue != NULL)
      {
        TempVariant.getLong (m_LongValue);
      }
    else if (m_DoubleValue != NULL)
      {
        TempVariant.getDouble (m_DoubleValue);
      }
    return IsOk;
}

//-------------------------------------------------------------------------

bool wxNumberValidator::transferFromWindowHelper (const wxString & TextCtrlContentString,
                                                  wxNumberValidatorVariant * Variant, 
                                                  wxString & ErrorMessageString)
{
    wxString TrimmedInputString = TextCtrlContentString;
    TrimmedInputString.Trim (FALSE);
    TrimmedInputString.Trim (TRUE);

    wxNumberValidatorVariant TempVariant;
    if ((m_Flags & IsEmptyAllowed) && TrimmedInputString.IsEmpty())
      {
        TempVariant = m_UndefinedVariant;
      }
    else
      {
        if ((!convertStringToVariant (TrimmedInputString, TempVariant))
            || !checkValue (TempVariant))
          {
            getErrorMessageString (TempVariant, ErrorMessageString);
            return FALSE;
          }
      }
    *Variant = TempVariant;
    return TRUE;
}

bool wxNumberValidator::convertStringToVariant (const wxString & TrimmedInputString,
                                                wxNumberValidatorVariant & Variant)
{
    if (m_LongValue != NULL
        || m_IntegerValue != NULL)
      {
        long TempLong;
        bool IsOk = convertStringToLong (TrimmedInputString, TempLong);
        Variant.setLong (TempLong);
        return IsOk;
      }
    else if (m_DoubleValue != NULL)
      {
        char DummyChar;
        double TempDouble;
        int ReadArgumentCount = wxSscanf (TrimmedInputString, "%lf%c", 
                                          & TempDouble,
                                          & DummyChar);
        Variant.setDouble (TempDouble);
        return (ReadArgumentCount == 1);
      }
    else
      return FALSE;
}

bool wxNumberValidator::checkValue (const wxNumberValidatorVariant & Variant)
{
    if (m_LongValue != NULL
        || m_IntegerValue != NULL)
      {
        long Long;
        long MinLong;
        long MaxLong;
        Variant.getLong (& Long);
        m_MinVariant.getLong (& MinLong);
        m_MaxVariant.getLong (& MaxLong);
        return (Long >= MinLong && Long <= MaxLong);
      }
    else if (m_DoubleValue != NULL)
      {
        double Double;
        double MinDouble;
        double MaxDouble;
        Variant.getDouble (& Double);
        m_MinVariant.getDouble (& MinDouble);
        m_MaxVariant.getDouble (& MaxDouble);
        return (Double >= MinDouble && Double <= MaxDouble);
      }
    return FALSE;
}

void wxNumberValidator::getErrorMessageString (const wxNumberValidatorVariant & WXUNUSED(Variant), 
                                               wxString & ErrorMessageString)
{
    ErrorMessageString = "";

    if (m_LongValue != NULL
        || m_IntegerValue != NULL)
      {
        long MinLong;
        long MaxLong;
        m_MinVariant.getLong (& MinLong);
        m_MaxVariant.getLong (& MaxLong);

        ErrorMessageString 
          += MessageFormatter (_("ERROR: input must be a number between "
                                 "%1 and %2%3 for \"%4\"."))
          % wxFormat (m_FormatString, MinLong)
          % wxFormat (m_FormatString, MaxLong)
          % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
          % m_FieldNameString;
      }
    else if (m_DoubleValue != NULL)
      {
        double MinDouble;
        double MaxDouble;
        m_MinVariant.getDouble (& MinDouble);
        m_MaxVariant.getDouble (& MaxDouble);

        ErrorMessageString 
          += MessageFormatter (_("ERROR: input must be a floating point number between %1 and %2%3 for \"%4\"."))
          % wxFormat (m_FormatString, MinDouble)
          % wxFormat (m_FormatString, MaxDouble)
          % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
          % m_FieldNameString;
      }
    else
      {
        ErrorMessageString = _("[No error message string available.]");
      }
}

//-------------------------------------------------------------------------

void wxNumberValidator::handleValidInput (const wxNumberValidatorVariant & WXUNUSED(TempVariant))
{
}

//=========================================================================

bool convertStringToLong (const char * CharPtr, long & Long)
{
    // replacement for:
    // if (sscanf (CharPtr,"%d%c", & TempLong, &DummyChar) !=1 ) { // handle error }

    bool IsOk = FALSE;
    char * EndCharPtr = NULL;
	int Base = 10;
    long TempLong = strtol (CharPtr, & EndCharPtr, Base);

    if (EndCharPtr != NULL 
		&& EndCharPtr != CharPtr 
		&& *EndCharPtr == '\0')
      {
        // WARN should use macros for minimal/maximal long values
        // defined in some header file somewhere
		// using macros LONG_MAX and LONG_MIN may require #include <limits.h>
        if ((TempLong != LONG_MAX)
			&& (TempLong != LONG_MIN))
		  {
			IsOk = TRUE;
			Long = TempLong;
		  }
	  }
	return IsOk;
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxRONumberValidator, wxNumberValidator)

//-------------------------------------------------------------------------

wxRONumberValidator::wxRONumberValidator()
{
}

wxRONumberValidator::wxRONumberValidator(int * IntegerValue,
                                         int Flags, int UndefinedInteger)
  : wxNumberValidator (IntegerValue, 0, 0, NULL, wxEmptyString, Flags, UndefinedInteger)
{
}

wxRONumberValidator::wxRONumberValidator(long * LongValue,
                                         int Flags, int UndefinedLong)
  : wxNumberValidator (LongValue, 0L, 0L, NULL, wxEmptyString, Flags, UndefinedLong)
{
}

//=========================================================================

wxDateTime::Month getMonthFromMonthIndex (int MonthIndex) // MonthIndex starting from 1, _not_ 0!
{
    switch (MonthIndex)
      {
        case 1: return wxDateTime::Jan;
        case 2: return wxDateTime::Feb;
        case 3: return wxDateTime::Mar;
        case 4: return wxDateTime::Apr;
        case 5: return wxDateTime::May;
        case 6: return wxDateTime::Jun;
        case 7: return wxDateTime::Jul;
        case 8: return wxDateTime::Aug;
        case 9: return wxDateTime::Sep;
        case 10: return wxDateTime::Oct;
        case 11: return wxDateTime::Nov;
        case 12: return wxDateTime::Dec;
      }
    return wxDateTime::Inv_Month;
}

int getMonthIndexFromMonth (wxDateTime::Month Month) // MonthIndex starting from 1, _not_ 0!
{
    switch (Month)
      {
        case wxDateTime::Jan: return 1;
        case wxDateTime::Feb: return 2;
        case wxDateTime::Mar: return 3;
        case wxDateTime::Apr: return 4;
        case wxDateTime::May: return 5;
        case wxDateTime::Jun: return 6;
        case wxDateTime::Jul: return 7;
        case wxDateTime::Aug: return 8;
        case wxDateTime::Sep: return 9;
        case wxDateTime::Oct: return 10;
        case wxDateTime::Nov: return 11;
        case wxDateTime::Dec: return 12;
      default:
        break;
      }
    return 0;
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxDateTimeValidator, wxTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxDateTimeValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

//-------------------------------------------------------------------------

wxDateTimeValidator::wxDateTimeValidator()
{
    m_DateTimeValue = NULL;
    m_FieldNameString = "";
}

wxDateTimeValidator::wxDateTimeValidator(wxDateTime * DateTime, 
                                         wxStatusMessageTarget * StatusMessageTarget,
                                         const wxString & FieldNameString,
                                         int Flags)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_DateTimeValue = DateTime;
    m_FieldNameString = FieldNameString;
}

wxDateTimeValidator::wxDateTimeValidator(const wxDateTimeValidator& DateTimeValidator)
    : wxTextCtrlStatusValidator()
{
    Copy(DateTimeValidator);
}

bool wxDateTimeValidator::Copy(const wxDateTimeValidator& DateTimeValidator)
{
    wxTextCtrlStatusValidator::Copy(DateTimeValidator);

    m_DateTimeValue = DateTimeValidator.m_DateTimeValue ;
    m_FieldNameString = DateTimeValidator.m_FieldNameString;

    return TRUE;
}

wxDateTimeValidator::~wxDateTimeValidator()
{
}

//-------------------------------------------------------------------------

void wxDateTimeValidator::transferToWindow (wxString & TextCtrlContentString)
{
    transferToWindowHelper (* m_DateTimeValue, TextCtrlContentString);
}

void wxDateTimeValidator::transferToWindowHelper (const wxDateTime & TempDateTime, wxString & TextCtrlContentString)
{
    if ((m_Flags & IsEmptyAllowed) 
        && (TempDateTime.IsValid()))
      {
        TextCtrlContentString = "";
      }
    else
      {
        formatDate (TempDateTime, TextCtrlContentString);
      }
}

//-------------------------------------------------------------------------

bool wxDateTimeValidator::transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                                       wxString & ErrorMessageString,
                                                       bool IsTextCtrlChangeEvent)
{
    wxDateTime TempDateTime;
    bool IsOk = transferFromWindowHelper (TextCtrlContentString,
                                          & TempDateTime, ErrorMessageString);
    if (IsOk && IsTextCtrlChangeEvent)
      handleValidInput (TempDateTime);

    return IsOk;
}

bool wxDateTimeValidator::transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                                        wxString & ErrorMessageString)
{
    bool IsOk = TRUE;
    if (m_DateTimeValue)
      {
        IsOk = transferFromWindowHelper (TextCtrlContentString,
                                         m_DateTimeValue, ErrorMessageString);
      }
    return IsOk;
}

//-------------------------------------------------------------------------

bool wxDateTimeValidator::transferFromWindowHelper (const wxString & TextCtrlContentString,
                                                    wxDateTime * DateTime, 
                                                    wxString & ErrorMessageString)
{
    wxString TrimmedInputString = TextCtrlContentString;
    TrimmedInputString.Trim (FALSE);
    TrimmedInputString.Trim (TRUE);

    wxDateTime TempDateTime = wxInvalidDateTime;
    if ((m_Flags & IsEmptyAllowed) && TrimmedInputString.IsEmpty())
      {
        TempDateTime = wxInvalidDateTime;
      }
    else
      {
        bool IsOk = parseDate (TrimmedInputString, TempDateTime);
        if (IsOk)
          {
            if (!checkValue (TempDateTime))
              IsOk = FALSE;
          }

        if (!IsOk)
          {
            // TODO: the error message should contain information about
            // which date date format(s) are accepted for the current locale
            getErrorMessageString (TempDateTime, ErrorMessageString);
            return FALSE;
          }
      }
    *DateTime = TempDateTime;
    return TRUE;
}

bool wxDateTimeValidator::checkValue (const wxDateTime & DateTime)
{
    return DateTime.IsValid();
    // return TRUE;
}

void wxDateTimeValidator::getErrorMessageString (const wxDateTime & WXUNUSED(DateTime), 
                                                 wxString & ErrorMessageString)
{
    ErrorMessageString
      += MessageFormatter (_("ERROR: input must be a valid date%1 for \"%2\""))
      % ((m_Flags & IsEmptyAllowed) ? _(" (or empty)") : "")
      % m_FieldNameString;
}

//-------------------------------------------------------------------------

void wxDateTimeValidator::handleValidInput (const wxDateTime & WXUNUSED(DateTime))
{
}

//=========================================================================

IMPLEMENT_DYNAMIC_CLASS(wxStringValidator, wxTextCtrlStatusValidator)

BEGIN_EVENT_TABLE(wxStringValidator, wxTextCtrlStatusValidator)
END_EVENT_TABLE()

// WARN this should be better of type size_t:
const int UnlimitedStringLength = -1;

//-------------------------------------------------------------------------

wxStringValidator::wxStringValidator()
{
    m_StringValue = NULL;
    m_FieldNameString = "";
    m_MaxStringLength = UnlimitedStringLength;
    m_Flags = 0;
    m_UndefinedString = "";
}

wxStringValidator::wxStringValidator(wxString * StringValue, 
                                     wxStatusMessageTarget * StatusMessageTarget,
                                     const wxString & FieldNameString,
                                     int MaxStringLength,
                                     int Flags, const wxString & UndefinedString)
  : wxTextCtrlStatusValidator (StatusMessageTarget, Flags)
{
    m_StringValue = StringValue;
    m_FieldNameString = FieldNameString;
    m_MaxStringLength = MaxStringLength;
    m_Flags = Flags;
    m_UndefinedString = UndefinedString;
}

wxStringValidator::wxStringValidator(const wxStringValidator& StringValidator)
    : wxTextCtrlStatusValidator()
{
    Copy(StringValidator);
}

bool wxStringValidator::Copy(const wxStringValidator& StringValidator)
{
    wxTextCtrlStatusValidator::Copy(StringValidator);

    m_StringValue = StringValidator.m_StringValue;
    m_FieldNameString = StringValidator.m_FieldNameString;
    m_MaxStringLength = StringValidator.m_MaxStringLength;
    m_Flags = StringValidator.m_Flags;
    m_UndefinedString = StringValidator.m_UndefinedString;

    return TRUE;
}

wxStringValidator::~wxStringValidator()
{
}

//-------------------------------------------------------------------------

void wxStringValidator::transferToWindow (wxString & TextCtrlContentString)
{
    transferToWindowHelper (*m_StringValue, TextCtrlContentString);
}

void wxStringValidator::transferToWindowHelper (const wxString & String, 
                                                wxString & TextCtrlContentString)
{
    if ((m_Flags & IsEmptyAllowed) && (String == m_UndefinedString))
      {
        TextCtrlContentString = "";
      }
    else
      {
        TextCtrlContentString = String;
      }
}

//-------------------------------------------------------------------------

bool wxStringValidator::transferFromWindowTemporary (const wxString & TextCtrlContentString,
                                                     wxString & ErrorMessageString,
                                                     bool IsTextCtrlChangeEvent)
{
    wxString TempString;
    bool IsOk = transferFromWindowHelper (TextCtrlContentString,
                                          & TempString, ErrorMessageString);
    if (IsOk && IsTextCtrlChangeEvent)
      handleValidInput (TempString);

    return IsOk;
}

bool wxStringValidator::transferFromWindowPersistent (const wxString & TextCtrlContentString,
                                                      wxString & ErrorMessageString)
{
    bool IsOk = TRUE;
    if (m_StringValue)
      {
        IsOk = transferFromWindowHelper (TextCtrlContentString,
                                         m_StringValue, ErrorMessageString);
      }
    return IsOk;
}

//-------------------------------------------------------------------------

bool wxStringValidator::transferFromWindowHelper (const wxString & TextCtrlContentString,
                                                  wxString * String, 
                                                  wxString & ErrorMessageString)
{
    wxString TempString = TextCtrlContentString;
    // if trimming is desired:
    // TODO: add a flag like 'IsRemoveLeadingTrainlingSpaces'
    // TempString.Trim (FALSE);
    // TempString.Trim (TRUE);

    if ((m_Flags & IsEmptyAllowed) && TempString.IsEmpty())
      {
        TempString = m_UndefinedString;
      }
    else
      {
        if (!checkValue (TempString))
          {
            getErrorMessageString (TempString, ErrorMessageString);
            return FALSE;
          }
      }
    *String = TempString;
    return TRUE;
}

bool wxStringValidator::checkValue (const wxString & String)
{
    bool IsOK = TRUE;
    if (m_MaxStringLength != UnlimitedStringLength)
      {
        if (cast_is_greater (String.Length(), m_MaxStringLength))
          IsOK = FALSE;
      }
    return IsOK;
}

void wxStringValidator::getErrorMessageString (const wxString & WXUNUSED(String), 
                                               wxString & ErrorMessageString)
{
    wxString MaxStringLengthDescriptionString;
    if (m_MaxStringLength != UnlimitedStringLength)
      {
        MaxStringLengthDescriptionString 
          = wxFormatMessage (_("with no more than %1 characters "), m_MaxStringLength);
      }

    ErrorMessageString = wxFormatMessage 
      (_("ERROR: input must be a string %1%2for \"%3\"."),
       MaxStringLengthDescriptionString,
       m_Flags & IsEmptyAllowed ? _("(or empty) ") : "",
       m_FieldNameString);
}

//-------------------------------------------------------------------------

void wxStringValidator::handleValidInput (const wxString & WXUNUSED(String))
{
}

//=========================================================================

