
/*
-------------------------------------------------------------------------
This file is part of ImageMagickExtensions library.
-------------------------------------------------------------------------

ImageMagickExtensions library 0.0.1
-----------------------------------

COPYRIGHT NOTICE:

ImageMagickExtensions library Copyright (c) 2004 Daniel Kps.

The ImageMagickExtensions library and associated documentation files (the
"Software") is provided "AS IS".  The author(s) disclaim all
warranties, expressed or implied, including, without limitation, the
warranties of merchantability and of fitness for any purpose.  The
author(s) assume no liability for direct, indirect, incidental,
special, exemplary, or consequential damages, which may result from
the use of or other dealings in the Software, even if advised of the
possibility of such damage.

Permission is hereby granted, free of charge, to any person obtaining
a copy of this Software, to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

 1. The origin of this source code must not be misrepresented.
 2. Altered versions must be plainly marked as such and must not be
    misrepresented as being the original source.
 3. This Copyright notice may not be removed or altered from any 
    source or altered source distribution.

End of ImageMagickExtensions library Copyright notice

-------------------------------------------------------------------------
*/

#ifndef _INCLUDED_ImageMagickExtensions_h
#define _INCLUDED_ImageMagickExtensions_h

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

// #include "magick/hashmap.h"


/*-----------------------------------------------------------------------*/

typedef HGLOBAL HDIB;

extern MagickExport int GetActualUsedColorCountInDIB (BITMAPINFOHEADER * BitmapInfoHeader);
extern MagickExport int GetActualUsedColorCountInDIBHandle (HDIB DIBHandle);

// NOTE expansion of 1-Bit images will make the expanded image 32 times 
// as big and thus may lead to really big images
int ExpandDIBPixelRow (BITMAPINFOHEADER * BitmapInfoHeader,
                       RGBQUAD * PaletteRGBAArray,
                       unsigned long PixelCount, 
                       BYTE * DIBPixelDataPtr,
                       BYTE * ExpandedPixelDataPtr);

MagickExport int DIBPaletteToImage (HDIB DIBHandle, Image ** PaletteImage,
                                    ExceptionInfo * exceptionInfo);
  
MagickExport int ImportExportColorPaletteIntoDIB (BYTE * ImportExportColorPaletteByteArray, 
                                                  int ImportExportColorPaletteEntryCount,
                                                  HDIB DIBHandle,
                                                  int IsImport);

MagickExport int ImageToDIBPalette (Image* image, HDIB DIBHandle,
                                    ExceptionInfo * exceptionInfo);

extern MagickExport Image * DIBToImage (HDIB DIB,
                                        ExceptionInfo * exceptionInfo);
extern MagickExport HDIB ImageToDIB (Image * image, int DIBBitsPerPixel,
                                     ExceptionInfo * exceptionInfo);

/*-----------------------------------------------------------------------*/

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif // _INCLUDED_ImageMagickExtensions_h

